/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.async.api.EventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.SEDA;
import com.tc.async.api.Sink;
import com.tc.async.api.Stage;
import com.tc.async.api.StageManager;
import com.tc.cluster.ClientChannelEventController;
import com.tc.entity.DiagnosticMessageImpl;
import com.tc.entity.DiagnosticResponse;
import com.tc.entity.DiagnosticResponseImpl;
import com.tc.entity.LinearVoltronEntityMultiResponse;
import com.tc.entity.NetworkVoltronEntityMessageImpl;
import com.tc.entity.ReplayVoltronEntityMultiResponse;
import com.tc.entity.VoltronEntityAppliedResponseImpl;
import com.tc.entity.VoltronEntityMultiResponse;
import com.tc.entity.VoltronEntityReceivedResponseImpl;
import com.tc.entity.VoltronEntityResponse;
import com.tc.entity.VoltronEntityRetiredResponseImpl;
import com.tc.lang.TCThreadGroup;
import com.tc.logging.ClientIDLogger;
import com.tc.logging.ClientIDLoggerProvider;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.TCSocketAddress;
import com.tc.net.basic.BasicConnectionManager;
import com.tc.net.core.ProductID;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.core.TCConnectionManagerImpl;
import com.tc.net.protocol.PlainNetworkStackHarnessFactory;
import com.tc.net.protocol.tcm.ChannelEvent;
import com.tc.net.protocol.tcm.ChannelEventListener;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.CommunicationsManager;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.MessageMonitorImpl;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageHydrateAndConvertSink;
import com.tc.net.protocol.tcm.TCMessageHydrateSink;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageRouterImpl;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.HealthCheckerConfigClientImpl;
import com.tc.net.protocol.transport.NullConnectionPolicy;
import com.tc.net.protocol.transport.ReconnectionRejectedHandlerL1;
import com.tc.net.protocol.transport.TransportHandshakeException;
import com.tc.object.ClientBuilder;
import com.tc.object.ClientBuilderFactory;
import com.tc.object.ClientConfigurationContext;
import com.tc.object.ClientEntityManager;
import com.tc.object.ClientShutdownManager;
import com.tc.object.handler.ClientCoordinationHandler;
import com.tc.object.handshakemanager.ClientHandshakeManager;
import com.tc.object.handshakemanager.ClientHandshakeManagerImpl;
import com.tc.object.msg.ClientHandshakeAckMessageImpl;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.msg.ClientHandshakeMessageFactory;
import com.tc.object.msg.ClientHandshakeMessageImpl;
import com.tc.object.msg.ClientHandshakeRefusedMessageImpl;
import com.tc.object.msg.ClientHandshakeResponse;
import com.tc.object.msg.ClusterMembershipMessage;
import com.tc.object.request.MultiRequestReceiveHandler;
import com.tc.object.request.RequestReceiveHandler;
import com.tc.object.session.SessionManagerImpl;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;
import com.tc.stats.counter.CounterManager;
import com.tc.stats.counter.CounterManagerImpl;
import com.tc.text.MapListPrettyPrint;
import com.tc.util.Assert;
import com.tc.util.CommonShutDownHook;
import com.tc.util.ProductInfo;
import com.tc.util.TCTimeoutException;
import com.tc.util.UUID;
import com.tc.util.concurrent.SetOnceFlag;
import com.tc.util.concurrent.SetOnceRef;
import com.tc.util.runtime.ThreadDumpUtil;
import com.tc.util.sequence.Sequence;
import com.tc.util.sequence.SimpleSequence;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedObjectClient {
    protected static final Logger DSO_LOGGER = LoggerFactory.getLogger(DistributedObjectClient.class);
    private final ClientBuilder clientBuilder;
    private final Iterable<InetSocketAddress> serverAddresses;
    private final TCThreadGroup threadGroup;
    private ClientMessageChannel channel;
    private TCConnectionManager connectionManager;
    private CommunicationsManager communicationsManager;
    private ClientHandshakeManager clientHandshakeManager;
    private CounterManager counterManager;
    private final String uuid;
    private final String name;
    private ClientShutdownManager shutdownManager;
    private final SetOnceFlag clientStopped = new SetOnceFlag();
    private final SetOnceFlag connectionMade = new SetOnceFlag();
    private final SetOnceRef<Thread> connectionThread = new SetOnceRef();
    private final SetOnceRef<Exception> exceptionMade = new SetOnceRef();
    private ClientEntityManager clientEntityManager;
    private RequestReceiveHandler singleMessageReceiver;
    private final StageManager communicationStageManager;
    private final boolean isAsync;

    public DistributedObjectClient(Iterable<InetSocketAddress> serverAddresses, TCThreadGroup threadGroup, Properties properties) {
        this(serverAddresses, ClientBuilderFactory.get(ClientBuilderFactory.class).create(properties), threadGroup, UUID.NULL_ID.toString(), "", false);
    }

    public DistributedObjectClient(Iterable<InetSocketAddress> serverAddresses, ClientBuilder builder, TCThreadGroup threadGroup, String uuid, String name, boolean asyncDrive) {
        Assert.assertNotNull(serverAddresses);
        this.serverAddresses = serverAddresses;
        this.threadGroup = threadGroup;
        this.clientBuilder = builder;
        this.uuid = uuid;
        this.name = name;
        this.isAsync = asyncDrive;
        SEDA seda = new SEDA(threadGroup);
        this.communicationStageManager = seda.getStageManager();
    }

    public synchronized void start() {
        String[] stringArray;
        ClientMessageChannel clientChannel;
        TCProperties tcProperties = TCPropertiesImpl.getProperties();
        int maxSize = tcProperties.getInt("l1.seda.stage.sink.capacity");
        SessionManagerImpl sessionManager = new SessionManagerImpl(new SessionManagerImpl.SequenceFactory(){

            @Override
            public Sequence newSequence() {
                return new SimpleSequence();
            }
        });
        WeakReference<DistributedObjectClient> ref = new WeakReference<DistributedObjectClient>(this);
        this.threadGroup.addCallbackOnExitDefaultHandler(state -> {
            DistributedObjectClient client = (DistributedObjectClient)ref.get();
            if (client != null) {
                DSO_LOGGER.info(client.getClientState());
            }
            Thread.dumpStack();
        });
        PlainNetworkStackHarnessFactory networkStackHarnessFactory = new PlainNetworkStackHarnessFactory();
        this.counterManager = new CounterManagerImpl();
        MessageMonitor mm = MessageMonitorImpl.createMonitor(tcProperties, DSO_LOGGER);
        TCMessageRouterImpl messageRouter = new TCMessageRouterImpl();
        HealthCheckerConfigClientImpl hc = new HealthCheckerConfigClientImpl(tcProperties.getPropertiesFor("l1.healthcheck.l2"), "TC Client");
        this.connectionManager = this.isAsync ? new TCConnectionManagerImpl("L1_L2", 0, hc, this.clientBuilder.createBufferManagerFactory()) : new BasicConnectionManager(this.name + "-" + this.uuid, this.clientBuilder.createBufferManagerFactory());
        this.communicationsManager = this.clientBuilder.createCommunicationsManager(mm, messageRouter, networkStackHarnessFactory, new NullConnectionPolicy(), this.connectionManager, hc, this.getMessageTypeClassMapping(), ReconnectionRejectedHandlerL1.SINGLETON);
        DSO_LOGGER.debug("Created CommunicationsManager.");
        int socketConnectTimeout = tcProperties.getInt("l1.socket.connect.timeout");
        if (socketConnectTimeout < 0) {
            throw new IllegalArgumentException("invalid socket time value: " + socketConnectTimeout);
        }
        this.channel = clientChannel = this.clientBuilder.createClientMessageChannel(this.communicationsManager, sessionManager, socketConnectTimeout);
        clientChannel.addListener(new ChannelEventListener(){

            @Override
            public void notifyChannelEvent(ChannelEvent event) {
                switch (event.getType()) {
                    case TRANSPORT_CLOSED_EVENT: 
                    case TRANSPORT_RECONNECTION_REJECTED_EVENT: {
                        DistributedObjectClient.this.shutdown();
                    }
                }
            }
        });
        ClientIDLoggerProvider cidLoggerProvider = new ClientIDLoggerProvider(clientChannel::getClientID);
        this.communicationStageManager.setLoggerProvider(cidLoggerProvider);
        DSO_LOGGER.debug("Created channel.");
        this.clientEntityManager = this.clientBuilder.createClientEntityManager(clientChannel, this.communicationStageManager);
        this.singleMessageReceiver = new RequestReceiveHandler(this.clientEntityManager);
        MultiRequestReceiveHandler mutil = new MultiRequestReceiveHandler(this.clientEntityManager);
        Stage<VoltronEntityMultiResponse> multiResponseStage = this.communicationStageManager.createStage("multi_request_ack_stage", VoltronEntityMultiResponse.class, mutil, 1, maxSize);
        clientChannel.addAttachment("ChannelStats", () -> {
            LinkedHashMap map = new LinkedHashMap();
            map.put("messageHandler", mutil.getStateMap());
            return map;
        }, true);
        ProductInfo pInfo = ProductInfo.getInstance();
        ClientHandshakeMessageFactory chmf = (u, n, c) -> {
            ClientMessageChannel cmc = this.getClientMessageChannel();
            if (cmc != null) {
                ClientHandshakeMessage rv = (ClientHandshakeMessage)cmc.createMessage(TCMessageType.CLIENT_HANDSHAKE_MESSAGE);
                rv.setClientVersion(c);
                rv.setClientPID(this.getPID());
                rv.setUUID(u);
                rv.setName(n);
                return rv;
            }
            return null;
        };
        this.clientHandshakeManager = this.clientBuilder.createClientHandshakeManager(new ClientIDLogger(clientChannel, LoggerFactory.getLogger(ClientHandshakeManagerImpl.class)), chmf, sessionManager, this.uuid, this.name, pInfo.version(), this.clientEntityManager);
        ClientChannelEventController.connectChannelEventListener(clientChannel, this.clientHandshakeManager);
        this.shutdownManager = new ClientShutdownManager(this);
        ClientConfigurationContext cc = new ClientConfigurationContext(this.communicationStageManager);
        if (clientChannel.getProductID() == ProductID.DIAGNOSTIC || !this.isAsync) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "multi_request_ack_stage";
        } else {
            stringArray = new String[]{};
        }
        String[] exclusion = stringArray;
        this.communicationStageManager.startAll(cc, Collections.emptyList(), exclusion);
        ClientCoordinationHandler handshake = new ClientCoordinationHandler(this.clientHandshakeManager);
        this.initChannelMessageRouter(messageRouter, EventHandler.directSink(handshake), this.isAsync ? multiResponseStage.getSink() : EventHandler.directSink(mutil));
        this.connectionThread.set(new Thread(this.threadGroup, () -> {
            if (!this.clientStopped.isSet()) {
                try {
                    this.openChannel(clientChannel);
                    this.waitForHandshake(clientChannel);
                    this.connectionMade();
                }
                catch (RuntimeException runtime) {
                    SetOnceFlag setOnceFlag = this.connectionMade;
                    synchronized (setOnceFlag) {
                        this.exceptionMade.set(runtime);
                        this.connectionMade.notifyAll();
                    }
                }
                catch (InterruptedException ie) {
                    SetOnceFlag setOnceFlag = this.connectionMade;
                    synchronized (setOnceFlag) {
                        this.exceptionMade.set(ie);
                        this.connectionMade.notifyAll();
                    }
                }
            }
        }, "Connection Maker - " + this.uuid));
        this.connectionThread.get().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionMade() {
        this.connectionMade.attemptSet();
        SetOnceFlag setOnceFlag = this.connectionMade;
        synchronized (setOnceFlag) {
            this.connectionMade.notifyAll();
        }
    }

    public boolean waitForConnection(long timeout, TimeUnit units) throws InterruptedException {
        if (!this.connectionThread.isSet()) {
            throw new IllegalStateException("not started");
        }
        this.connectionThread.get().join(units.toMillis(timeout));
        if (this.exceptionMade.isSet()) {
            Exception exp = this.exceptionMade.get();
            throw new RuntimeException(exp);
        }
        return this.connectionMade.isSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openChannel(ClientMessageChannel channel) throws InterruptedException {
        while (!this.clientStopped.isSet()) {
            SetOnceFlag setOnceFlag;
            try {
                DSO_LOGGER.debug("Trying to open channel....");
                channel.open(this.serverAddresses);
                DSO_LOGGER.debug("Channel open");
                break;
            }
            catch (TCTimeoutException tcte) {
                DSO_LOGGER.info("Unable to connect to server/s {} ...sleeping for 5 sec.", this.serverAddresses);
                DSO_LOGGER.debug("Timeout connecting to server/s: {} {}", this.serverAddresses, (Object)tcte.getMessage());
                setOnceFlag = this.clientStopped;
                synchronized (setOnceFlag) {
                    this.clientStopped.wait(5000L);
                }
            }
            catch (ConnectException e) {
                DSO_LOGGER.info("Unable to connect to server/s {} ...sleeping for 5 sec.", this.serverAddresses);
                DSO_LOGGER.debug("Connection refused from server/s: {} {}", this.serverAddresses, (Object)e.getMessage());
                setOnceFlag = this.clientStopped;
                synchronized (setOnceFlag) {
                    this.clientStopped.wait(5000L);
                }
            }
            catch (MaxConnectionsExceededException e) {
                DSO_LOGGER.error(e.getMessage());
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (CommStackMismatchException e) {
                DSO_LOGGER.error(e.getMessage());
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (TransportHandshakeException handshake) {
                DSO_LOGGER.error(handshake.getMessage());
                throw new IllegalStateException(handshake.getMessage(), handshake);
            }
            catch (IOException ioe) {
                DSO_LOGGER.info("Unable to connect to server/s {} ...sleeping for 5 sec.", this.serverAddresses);
                DSO_LOGGER.debug("IOException connecting to server/s: {} {}", this.serverAddresses, (Object)ioe.getMessage());
                setOnceFlag = this.clientStopped;
                synchronized (setOnceFlag) {
                    this.clientStopped.wait(5000L);
                }
            }
        }
    }

    private void waitForHandshake(ClientMessageChannel channel) {
        this.clientHandshakeManager.waitForHandshake();
        ClientMessageChannel cmc = this.getClientMessageChannel();
        if (cmc != null) {
            TCSocketAddress remoteAddress = cmc.getRemoteAddress();
            String infoMsg = "Connection successfully established to server at " + remoteAddress;
            if (!channel.getProductID().isInternal() && channel.isConnected()) {
                DSO_LOGGER.info(infoMsg);
            }
        }
    }

    private Map<TCMessageType, Class<? extends TCMessage>> getMessageTypeClassMapping() {
        HashMap<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping = new HashMap<TCMessageType, Class<? extends TCMessage>>();
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_MESSAGE, ClientHandshakeMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_ACK_MESSAGE, ClientHandshakeAckMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_REFUSED_MESSAGE, ClientHandshakeRefusedMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLUSTER_MEMBERSHIP_EVENT_MESSAGE, ClusterMembershipMessage.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_MESSAGE, NetworkVoltronEntityMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_RECEIVED_RESPONSE, VoltronEntityReceivedResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_COMPLETED_RESPONSE, VoltronEntityAppliedResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_RETIRED_RESPONSE, VoltronEntityRetiredResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_MULTI_RESPONSE, LinearVoltronEntityMultiResponse.class);
        messageTypeClassMapping.put(TCMessageType.DIAGNOSTIC_REQUEST, DiagnosticMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.DIAGNOSTIC_RESPONSE, DiagnosticResponseImpl.class);
        return messageTypeClassMapping;
    }

    private void initChannelMessageRouter(TCMessageRouter messageRouter, Sink<ClientHandshakeResponse> ack, Sink<VoltronEntityMultiResponse> multiSink) {
        messageRouter.routeMessageType(TCMessageType.CLIENT_HANDSHAKE_ACK_MESSAGE, new TCMessageHydrateSink<ClientHandshakeResponse>(ack));
        messageRouter.routeMessageType(TCMessageType.CLIENT_HANDSHAKE_REFUSED_MESSAGE, new TCMessageHydrateSink<ClientHandshakeResponse>(ack));
        messageRouter.routeMessageType(TCMessageType.CLIENT_HANDSHAKE_REDIRECT_MESSAGE, new TCMessageHydrateSink<ClientHandshakeResponse>(ack));
        messageRouter.routeMessageType(TCMessageType.CLUSTER_MEMBERSHIP_EVENT_MESSAGE, new TCMessageHydrateSink<Object>(context -> {}));
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_RECEIVED_RESPONSE, new TCMessageHydrateAndConvertSink<VoltronEntityResponse, VoltronEntityMultiResponse>(multiSink, this::convertSingleToMulti));
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_COMPLETED_RESPONSE, new TCMessageHydrateAndConvertSink<VoltronEntityResponse, VoltronEntityMultiResponse>(multiSink, this::convertSingleToMulti));
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_RETIRED_RESPONSE, new TCMessageHydrateAndConvertSink<VoltronEntityResponse, VoltronEntityMultiResponse>(multiSink, this::convertSingleToMulti));
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_MULTI_RESPONSE, new TCMessageHydrateSink<VoltronEntityMultiResponse>(multiSink));
        messageRouter.routeMessageType(TCMessageType.DIAGNOSTIC_RESPONSE, new TCMessageHydrateAndConvertSink<VoltronEntityResponse, VoltronEntityMultiResponse>(multiSink, this::convertSingleToMulti));
        DSO_LOGGER.debug("Added message routing types.");
    }

    private VoltronEntityMultiResponse convertSingleToMulti(final VoltronEntityResponse response) {
        if (response instanceof DiagnosticResponse) {
            this.clientEntityManager.complete(response.getTransactionID(), ((DiagnosticResponse)response).getResponse());
            return null;
        }
        return new ReplayVoltronEntityMultiResponse(){

            @Override
            public int replay(VoltronEntityMultiResponse.ReplayReceiver receiver) {
                try {
                    DistributedObjectClient.this.singleMessageReceiver.handleEvent(response);
                    return 1;
                }
                catch (EventHandlerException ee) {
                    throw new RuntimeException(ee);
                }
            }
        };
    }

    public ClientEntityManager getEntityManager() {
        return this.clientEntityManager;
    }

    public CommunicationsManager getCommunicationsManager() {
        return this.communicationsManager;
    }

    public ClientHandshakeManager getClientHandshakeManager() {
        return this.clientHandshakeManager;
    }

    public String getClientState() {
        MapListPrettyPrint printer = new MapListPrettyPrint();
        this.communicationStageManager.prettyPrint(printer);
        this.clientEntityManager.prettyPrint(printer);
        return ((Object)printer).toString();
    }

    public void dump() {
        DSO_LOGGER.info(this.getClientState());
    }

    public void shutdown() {
        this.shutdown(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownResources() {
        ClientMessageChannel clientChannel;
        Logger logger = DSO_LOGGER;
        if (this.counterManager != null) {
            try {
                this.counterManager.shutdown();
            }
            catch (Throwable t) {
                logger.error("error shutting down counter manager", t);
            }
            finally {
                this.counterManager = null;
            }
        }
        if ((clientChannel = this.getClientMessageChannel()) != null) {
            try {
                clientChannel.close();
            }
            catch (Throwable t) {
                logger.error("Error closing channel", t);
            }
        }
        if (this.communicationsManager != null) {
            try {
                this.communicationsManager.shutdown();
            }
            catch (Throwable t) {
                logger.error("Error shutting down communications manager", t);
            }
            finally {
                this.communicationsManager = null;
            }
        }
        if (this.connectionManager != null) {
            try {
                this.connectionManager.shutdown();
            }
            catch (Throwable t) {
                logger.error("Error shutting down connection manager", t);
            }
            finally {
                this.connectionManager = null;
            }
        }
        try {
            this.communicationStageManager.stopAll();
        }
        catch (Throwable t) {
            logger.error("Error stopping stage manager", t);
        }
        CommonShutDownHook.shutdown();
        if (this.threadGroup != null) {
            boolean interrupted = false;
            try {
                long end = System.currentTimeMillis() + TCPropertiesImpl.getProperties().getLong("l1.shutdown.threadgroup.gracetime");
                List<Thread> liveThreads = DistributedObjectClient.getLiveThreads(this.threadGroup);
                long time = System.currentTimeMillis();
                while (!liveThreads.isEmpty() && System.currentTimeMillis() < end) {
                    for (Thread t : liveThreads) {
                        if (System.currentTimeMillis() > end) break;
                        long start = System.currentTimeMillis();
                        if (t.isAlive() && Thread.currentThread() != t) {
                            t.join(1000L);
                        }
                        if (t.isAlive()) continue;
                        logger.debug("Destroyed thread " + t.getName() + " time to destroy:" + (System.currentTimeMillis() - start) + " millis");
                    }
                    liveThreads = DistributedObjectClient.getLiveThreads(this.threadGroup);
                }
                logger.debug("time to destroy thread group:" + TimeUnit.SECONDS.convert(System.currentTimeMillis() - time, TimeUnit.MILLISECONDS) + " seconds");
                if (!DistributedObjectClient.getLiveThreads(this.threadGroup).isEmpty()) {
                    logger.warn("Timed out waiting for TC thread group threads to die for connection " + this.name + "/" + this.uuid + " - probable shutdown memory leak\nLive threads: " + DistributedObjectClient.getLiveThreads(this.threadGroup) + " in thread group " + this.threadGroup);
                    Thread threadGroupCleanerThread = new Thread(this.threadGroup.getParent(), new TCThreadGroupCleanerRunnable(this.threadGroup), "TCThreadGroup last chance cleaner thread");
                    logger.warn(ThreadDumpUtil.getThreadDump());
                    threadGroupCleanerThread.setDaemon(true);
                    threadGroupCleanerThread.start();
                    logger.warn("Spawning TCThreadGroup last chance cleaner thread");
                } else {
                    logger.debug("Destroying TC thread group");
                    if (this.threadGroup != Thread.currentThread().getThreadGroup()) {
                        this.threadGroup.destroy();
                    }
                }
            }
            catch (Throwable t) {
                logger.error("Error destroying TC thread group", t);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (TCPropertiesImpl.getProperties().getBoolean("l1.shutdown.force.finalization")) {
            System.runFinalization();
        }
    }

    private static List<Thread> getLiveThreads(ThreadGroup group) {
        int estimate = group.activeCount();
        Thread[] threads = new Thread[estimate + 1];
        while (true) {
            int count;
            if ((count = group.enumerate(threads)) < threads.length) {
                ArrayList<Thread> l = new ArrayList<Thread>(count);
                for (Thread t : threads) {
                    if (t == null || t == Thread.currentThread()) continue;
                    l.add(t);
                }
                return l;
            }
            threads = new Thread[threads.length * 2];
        }
    }

    private void shutdownClient(boolean forceImmediate) {
        if (this.shutdownManager != null) {
            this.shutdownManager.execute(forceImmediate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean forceImmediate) {
        if (this.connectionThread.isSet()) {
            this.connectionThread.get().interrupt();
        }
        if (this.clientStopped.attemptSet()) {
            SetOnceFlag setOnceFlag = this.clientStopped;
            synchronized (setOnceFlag) {
                this.clientStopped.notifyAll();
            }
            ClientMessageChannel clientChannel = this.getClientMessageChannel();
            if (clientChannel != null && !clientChannel.getProductID().isInternal() && clientChannel.isConnected()) {
                DSO_LOGGER.info("closing down Terracotta Connection force=" + forceImmediate + " channel=" + clientChannel.getChannelID() + " client=" + clientChannel.getClientID());
            }
            this.shutdownClient(forceImmediate);
        }
    }

    private int getPID() {
        String vmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = vmName.indexOf(64);
        if (index < 0) {
            throw new RuntimeException("unexpected format: " + vmName);
        }
        return Integer.parseInt(vmName.substring(0, index));
    }

    private synchronized ClientMessageChannel getClientMessageChannel() {
        return this.channel;
    }

    private static class TCThreadGroupCleanerRunnable
    implements Runnable {
        private final TCThreadGroup threadGroup;

        public TCThreadGroupCleanerRunnable(TCThreadGroup threadGroup) {
            this.threadGroup = threadGroup;
        }

        @Override
        public void run() {
            for (Thread liveThread : DistributedObjectClient.getLiveThreads(this.threadGroup)) {
                Exception e = new Exception("thread is stuck " + liveThread.getName());
                e.setStackTrace(liveThread.getStackTrace());
                DSO_LOGGER.warn("stray connection threads not stopping", (Throwable)e);
                liveThread.interrupt();
                try {
                    liveThread.join(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                this.threadGroup.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

