/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.object.ClientBuilder;
import com.tc.util.ManagedServiceLoader;
import java.util.Properties;

public interface ClientBuilderFactory {
    public static final String CLIENT_BUILDER_TYPE = "client.builder.type";

    public static <T> T get(Class<T> type) {
        T finalFactory = null;
        for (T factory : ManagedServiceLoader.loadServices(type, ClientBuilderFactory.class.getClassLoader())) {
            if (finalFactory == null) {
                finalFactory = factory;
                continue;
            }
            throw new RuntimeException("Found multiple implementations of " + type.getName());
        }
        return finalFactory;
    }

    public ClientBuilder create(Properties var1);

    public static enum ClientBuilderType {
        TERRACOTTA,
        DIAGNOSTIC;


        public static ClientBuilderType of(String name) {
            for (ClientBuilderType type : ClientBuilderType.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Couldn't find enum with name " + name);
        }
    }
}

