/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.client.ClientFactory;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.lang.L1ThrowableHandler;
import com.tc.lang.TCThreadGroup;
import com.tc.object.ClientBuilder;
import com.tc.object.DistributedObjectClient;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.UUID;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

public class DistributedObjectClientFactory {
    private final Iterable<InetSocketAddress> serverAddresses;
    private final ClientBuilder builder;
    private final Properties properties;

    public DistributedObjectClientFactory(Iterable<InetSocketAddress> serverAddresses, ClientBuilder builder, Properties properties) {
        this.serverAddresses = serverAddresses;
        this.builder = builder;
        this.properties = properties;
        HashMap<String, String> props = new HashMap<String, String>();
        for (String n : properties.stringPropertyNames()) {
            if (!n.startsWith("com.tc")) continue;
            props.put(n.substring(7), properties.getProperty(n));
        }
        TCPropertiesImpl.getProperties().overwriteTcPropertiesFromConfig(props);
    }

    public DistributedObjectClient create() throws InterruptedException, ConfigurationSetupException {
        L1ThrowableHandler throwableHandler = new L1ThrowableHandler(LoggerFactory.getLogger(DistributedObjectClient.class), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return null;
            }
        });
        String uuid = this.properties.getProperty("connection.uuid", UUID.getUUID().toString());
        String name = this.properties.getProperty("connection.name", "");
        TCThreadGroup group = new TCThreadGroup(throwableHandler, name + "/" + uuid);
        boolean async = Boolean.parseBoolean(this.properties.getProperty("connection.async", "false"));
        DistributedObjectClient client = ClientFactory.createClient(this.serverAddresses, this.builder, group, uuid, name, async);
        WeakReference<DistributedObjectClient> ref = new WeakReference<DistributedObjectClient>(client);
        group.addCallbackOnExitDefaultHandler(state -> {
            DistributedObjectClient ce = (DistributedObjectClient)ref.get();
            if (ce != null) {
                ce.dump();
                ce.shutdown();
            }
        });
        try {
            client.start();
            String timeout = this.properties.getProperty("connection.timeout", "0");
            if (!client.waitForConnection(Long.parseLong(timeout), TimeUnit.MILLISECONDS)) {
                client.shutdown();
                return null;
            }
        }
        catch (InterruptedException ie) {
            client.shutdown();
            return null;
        }
        catch (RuntimeException exp) {
            client.shutdown();
            throw exp;
        }
        catch (Error e) {
            client.shutdown();
            throw e;
        }
        return client;
    }
}

