/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.GeneratedMessageFactory;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageFactory;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.tcm.UnsupportedMessageTypeException;
import com.tc.object.session.SessionID;
import com.tc.object.session.SessionProvider;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.EnumMap;
import java.util.Map;

public class TCMessageFactoryImpl
implements TCMessageFactory {
    private final Map<TCMessageType, GeneratedMessageFactory> generators = new EnumMap<TCMessageType, GeneratedMessageFactory>(TCMessageType.class);
    private final MessageMonitor monitor;
    private final SessionProvider sessionProvider;

    public TCMessageFactoryImpl(SessionProvider sessionProvider, MessageMonitor monitor) {
        this.sessionProvider = sessionProvider;
        this.monitor = monitor;
    }

    @Override
    public TCMessage createMessage(MessageChannel source, TCMessageType type) throws UnsupportedMessageTypeException {
        GeneratedMessageFactory factory = this.lookupFactory(type);
        return factory.createMessage(this.sessionProvider.getSessionID(), this.monitor, TCMessageFactoryImpl.createBuffer(), source, type);
    }

    private static TCByteBufferOutputStream createBuffer() {
        return new TCByteBufferOutputStream();
    }

    @Override
    public TCMessage createMessage(MessageChannel source, TCMessageType type, TCMessageHeader header, TCByteBuffer[] data) {
        GeneratedMessageFactory factory = this.lookupFactory(type);
        return factory.createMessage(this.sessionProvider.getSessionID(), this.monitor, source, header, data);
    }

    @Override
    public void addClassMapping(TCMessageType type, GeneratedMessageFactory messageFactory) {
        if (type == null || messageFactory == null) {
            throw new IllegalArgumentException();
        }
        if (this.generators.put(type, messageFactory) != null) {
            throw new IllegalStateException("message already has class mapping: " + (Object)((Object)type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClassMapping(TCMessageType type, Class<? extends TCMessage> msgClass) {
        if (type == null || msgClass == null) {
            throw new IllegalArgumentException();
        }
        String string = msgClass.getName().intern();
        synchronized (string) {
            if (this.generators.put(type, new GeneratedMessageFactoryImpl(msgClass)) != null) {
                throw new IllegalStateException("message already has class mapping: " + (Object)((Object)type));
            }
        }
    }

    private GeneratedMessageFactory lookupFactory(TCMessageType type) {
        GeneratedMessageFactory factory = this.generators.get((Object)type);
        if (factory == null) {
            throw new RuntimeException("No factory for type " + (Object)((Object)type));
        }
        return factory;
    }

    private static class GeneratedMessageFactoryImpl
    implements GeneratedMessageFactory {
        private final MethodHandle sendHdl;
        private final MethodHandle recvHdl;

        GeneratedMessageFactoryImpl(Class<? extends TCMessage> msgClass) {
            this.sendHdl = GeneratedMessageFactoryImpl.findMethodHandle(msgClass, SessionID.class, MessageMonitor.class, TCByteBufferOutputStream.class, MessageChannel.class, TCMessageType.class);
            this.recvHdl = GeneratedMessageFactoryImpl.findMethodHandle(msgClass, SessionID.class, MessageMonitor.class, MessageChannel.class, TCMessageHeader.class, TCByteBuffer[].class);
            if (this.sendHdl == null && this.recvHdl == null) {
                throw new RuntimeException("No constructors available for " + msgClass);
            }
        }

        private static MethodHandle findMethodHandle(Class<? extends TCMessage> msgClass, Class<?> ... argTypes) {
            try {
                MethodType type = MethodType.methodType(Void.TYPE, argTypes);
                return MethodHandles.lookup().findConstructor(msgClass, type);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public TCMessage createMessage(SessionID sid, MessageMonitor monitor, TCByteBufferOutputStream output, MessageChannel channel, TCMessageType type) {
            if (this.sendHdl == null) {
                throw new UnsupportedOperationException();
            }
            try {
                return this.sendHdl.invoke(sid, monitor, output, channel, type);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public TCMessage createMessage(SessionID sid, MessageMonitor monitor, MessageChannel channel, TCMessageHeader msgHeader, TCByteBuffer[] data) {
            if (this.recvHdl == null) {
                throw new UnsupportedOperationException();
            }
            try {
                return this.recvHdl.invoke(sid, monitor, channel, msgHeader, data);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

