/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel;

import java.util.HashSet;
import java.util.Set;
import org.terracotta.runnel.EnumMapping;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.decoding.fields.ArrayField;
import org.terracotta.runnel.decoding.fields.BoolField;
import org.terracotta.runnel.decoding.fields.ByteBufferField;
import org.terracotta.runnel.decoding.fields.CharField;
import org.terracotta.runnel.decoding.fields.EnumField;
import org.terracotta.runnel.decoding.fields.FloatingPoint64Field;
import org.terracotta.runnel.decoding.fields.Int32Field;
import org.terracotta.runnel.decoding.fields.Int64Field;
import org.terracotta.runnel.decoding.fields.StringField;
import org.terracotta.runnel.decoding.fields.StructField;

public class StructBuilder {
    private final StructField structField = new StructField("root", -1);
    private final Set<String> names = new HashSet<String>();
    private int lastIndex = -1;

    public Struct build() {
        Struct struct = new Struct(this.structField);
        struct.init();
        return struct;
    }

    public Struct alias() {
        return new Struct(this.structField);
    }

    public static StructBuilder newStructBuilder() {
        return new StructBuilder();
    }

    public StructBuilder bool(String name, int index) {
        this.checkParams(name, index);
        this.structField.addField(new BoolField(name, index));
        return this;
    }

    public StructBuilder chr(String name, int index) {
        this.checkParams(name, index);
        this.structField.addField(new CharField(name, index));
        return this;
    }

    public <T> StructBuilder enm(String name, int index, EnumMapping<T> enumMapping) {
        this.checkParams(name, index);
        this.structField.addField(new EnumField<T>(name, index, enumMapping));
        return this;
    }

    public StructBuilder int32(String name, int index) {
        this.checkParams(name, index);
        this.structField.addField(new Int32Field(name, index));
        return this;
    }

    public StructBuilder int64(String name, int index) {
        this.checkParams(name, index);
        this.structField.addField(new Int64Field(name, index));
        return this;
    }

    public StructBuilder fp64(String name, int index) {
        this.checkParams(name, index);
        this.structField.addField(new FloatingPoint64Field(name, index));
        return this;
    }

    public StructBuilder string(String name, int index) {
        this.checkParams(name, index);
        this.structField.addField(new StringField(name, index));
        return this;
    }

    public StructBuilder byteBuffer(String name, int index) {
        this.checkParams(name, index);
        this.structField.addField(new ByteBufferField(name, index));
        return this;
    }

    public StructBuilder struct(String name, int index, Struct struct) {
        this.checkParams(name, index);
        this.structField.addField(struct.alias(name, index));
        return this;
    }

    public StructBuilder bools(String name, int index) {
        this.checkParams(name, index);
        this.structField.addField(new ArrayField(name, index, new BoolField(name, index)));
        return this;
    }

    public StructBuilder chrs(String name, int index) {
        this.checkParams(name, index);
        this.structField.addField(new ArrayField(name, index, new CharField(name, index)));
        return this;
    }

    public StructBuilder int32s(String name, int index) {
        this.checkParams(name, index);
        this.structField.addField(new ArrayField(name, index, new Int32Field(name, index)));
        return this;
    }

    public StructBuilder int64s(String name, int index) {
        this.checkParams(name, index);
        this.structField.addField(new ArrayField(name, index, new Int64Field(name, index)));
        return this;
    }

    public StructBuilder fp64s(String name, int index) {
        this.checkParams(name, index);
        this.structField.addField(new ArrayField(name, index, new FloatingPoint64Field(name, index)));
        return this;
    }

    public StructBuilder strings(String name, int index) {
        this.checkParams(name, index);
        this.structField.addField(new ArrayField(name, index, new StringField(name, index)));
        return this;
    }

    public StructBuilder structs(String name, int index, Struct struct) {
        this.checkParams(name, index);
        this.structField.addField(new ArrayField(name, index, struct.alias(name, index)));
        return this;
    }

    private void checkParams(String name, int index) {
        this.checkName(name);
        this.advanceIndex(index);
    }

    private void advanceIndex(int index) {
        if (index <= 0) {
            throw new IllegalArgumentException("Index must be greater than zero : " + index);
        }
        if (index <= this.lastIndex) {
            throw new IllegalArgumentException("Index must be registered in growing order : " + index + " (last registered one : " + this.lastIndex + ")");
        }
        this.lastIndex = index;
    }

    private void checkName(String name) {
        if (!this.names.add(name)) {
            throw new IllegalArgumentException("Duplicate name : " + name);
        }
    }
}

