/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.service;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.service.MalformedClusterException;

public class ClusterValidator {
    private final Cluster cluster;

    public ClusterValidator(Cluster cluster) {
        this.cluster = cluster;
    }

    public void validate() throws MalformedClusterException {
        this.validateNodeName();
        this.validateAddresses();
        this.validateServerSettings();
        this.validateSecurityDir();
        this.validateFailoverSetting();
    }

    private void validateAddresses() {
        this.cluster.getStripes().stream().flatMap(s -> s.getNodes().stream().map(Node::getNodeAddress)).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).map(InetSocketAddress::toString).reduce((result, addr) -> result + ", " + addr).ifPresent(duplicates -> {
            throw new MalformedClusterException("Duplicate node addresses found: " + duplicates);
        });
    }

    private void validateFailoverSetting() {
        if (this.cluster.getFailoverPriority() == null) {
            throw new MalformedClusterException((Object)((Object)Setting.FAILOVER_PRIORITY) + " setting is missing");
        }
    }

    private void validateNodeName() {
        this.cluster.getNodes().stream().map(Node::getNodeName).filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).findAny().ifPresent(nodeName -> {
            throw new MalformedClusterException("Found duplicate node name: " + nodeName);
        });
    }

    private void validateServerSettings() {
        Collection settings = this.cluster.getNodes().stream().map(node -> node.getDataDirs().keySet()).collect(Collectors.toSet());
        if (settings.size() > 1) {
            String message = " If using -c option to add data dirs, use it multiple times to do for every node in cluster";
            throw new MalformedClusterException("Data directory names need to match across the cluster, but found the following mismatches: " + settings + message);
        }
    }

    private void validateSecurityDir() {
        if ("certificate".equals(this.cluster.getSecurityAuthc()) && !this.cluster.isSecuritySslTls()) {
            throw new MalformedClusterException((Object)((Object)Setting.SECURITY_SSL_TLS) + " is required for " + (Object)((Object)Setting.SECURITY_AUTHC) + "=certificate");
        }
        this.cluster.nodeContexts().forEach(nodeContext -> {
            Node node = nodeContext.getNode();
            if (this.cluster.getSecurityAuthc() != null && node.getSecurityDir() == null || node.getSecurityAuditLogDir() != null && node.getSecurityDir() == null || this.cluster.isSecuritySslTls() && node.getSecurityDir() == null || this.cluster.isSecurityWhitelist() && node.getSecurityDir() == null) {
                throw new MalformedClusterException((Object)((Object)Setting.SECURITY_DIR) + " is mandatory for any of the security configuration");
            }
            if (node.getSecurityDir() != null && !this.cluster.isSecuritySslTls() && this.cluster.getSecurityAuthc() == null && !this.cluster.isSecurityWhitelist()) {
                throw new MalformedClusterException("One of " + (Object)((Object)Setting.SECURITY_SSL_TLS) + ", " + (Object)((Object)Setting.SECURITY_AUTHC) + ", or " + (Object)((Object)Setting.SECURITY_WHITELIST) + " is required for security configuration");
            }
        });
    }
}

