/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.lease.LeaseAcquirer;
import org.terracotta.lease.LeaseEndpointDelegate;
import org.terracotta.lease.LeaseException;
import org.terracotta.lease.LeaseMessage;
import org.terracotta.lease.LeaseReconnectData;
import org.terracotta.lease.LeaseReconnectDataSupplier;
import org.terracotta.lease.LeaseReconnectListener;
import org.terracotta.lease.LeaseReconnectingException;
import org.terracotta.lease.LeaseRequest;
import org.terracotta.lease.LeaseRequestResult;
import org.terracotta.lease.LeaseResponse;

class LeaseAcquirerImpl
implements LeaseAcquirer,
LeaseReconnectListener,
LeaseReconnectDataSupplier {
    private final EntityClientEndpoint<LeaseMessage, LeaseResponse> endpoint;
    private final LeaseReconnectListener reconnectListener;
    private final AtomicLong connectionSequenceNumber = new AtomicLong();
    private volatile boolean reconnecting;

    LeaseAcquirerImpl(EntityClientEndpoint<LeaseMessage, LeaseResponse> endpoint, LeaseReconnectListener reconnectListener) {
        this.endpoint = endpoint;
        this.reconnectListener = reconnectListener;
        endpoint.setDelegate(new LeaseEndpointDelegate(this, this));
    }

    @Override
    public long acquireLease() throws LeaseException, InterruptedException {
        long currentConnectionSequenceNumber = this.connectionSequenceNumber.get();
        if (this.reconnecting) {
            throw new LeaseReconnectingException("Will not attempt to acquire a lease as a reconnection is taking place");
        }
        try {
            Future<LeaseResponse> invokeFuture = this.endpoint.message(new LeaseRequest(currentConnectionSequenceNumber)).invoke();
            LeaseRequestResult leaseRequestResult = (LeaseRequestResult)invokeFuture.get();
            if (!leaseRequestResult.isConnectionGood()) {
                throw new LeaseReconnectingException("Attempted to acquire a lease but fail-over occurred");
            }
            if (!leaseRequestResult.isLeaseGranted()) {
                throw new LeaseException("Unable to obtain lease, the connection is being closed because the lease was not renewed soon enough");
            }
            return leaseRequestResult.getLeaseLength();
        }
        catch (ExecutionException e) {
            throw new LeaseException(e.getCause());
        }
    }

    @Override
    public void close() {
        this.endpoint.close();
    }

    @Override
    public void reconnecting() {
        this.reconnecting = true;
        this.connectionSequenceNumber.incrementAndGet();
        this.reconnectListener.reconnecting();
    }

    @Override
    public void reconnected() {
        this.reconnecting = false;
        this.reconnectListener.reconnected();
    }

    @Override
    public LeaseReconnectData getReconnectData() {
        return new LeaseReconnectData(this.connectionSequenceNumber.get());
    }
}

