/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.connection;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.ServiceLoader;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionService;
import org.terracotta.connection.URIUtils;

public final class ConnectionFactory {
    public static Connection connect(URI uri, Properties properties) throws ConnectionException {
        ConnectionFactory.validateURI(uri);
        return ConnectionFactory.getConnectionService(uri).connect(uri, properties);
    }

    public static Connection connect(Iterable<InetSocketAddress> servers, Properties properties) throws ConnectionException {
        return ConnectionFactory.getConnectionService(properties).connect(servers, properties);
    }

    private static void validateURI(URI uri) throws ConnectionException {
        try {
            URIUtils.validateTerracottaURI(uri);
        }
        catch (URISyntaxException e) {
            throw new ConnectionException(e);
        }
    }

    private static ConnectionService getConnectionService(Properties properties) {
        String connectionType = properties.getProperty("connection.type", "terracotta");
        for (ConnectionService connectionService : ConnectionFactory.getServiceLoader()) {
            if (!connectionService.handlesConnectionType(connectionType)) continue;
            return connectionService;
        }
        throw new IllegalArgumentException("Unknown connection type " + connectionType);
    }

    private static ConnectionService getConnectionService(URI uri) {
        for (ConnectionService connectionService : ConnectionFactory.getServiceLoader()) {
            if (!connectionService.handlesURI(uri)) continue;
            return connectionService;
        }
        throw new IllegalArgumentException("Unknown URI " + uri);
    }

    private static ServiceLoader<ConnectionService> getServiceLoader() {
        return ServiceLoader.load(ConnectionService.class, ConnectionFactory.class.getClassLoader());
    }
}

