/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection.api;

import com.tc.object.ClientBuilderFactory;
import com.terracotta.connection.EndpointConnector;
import com.terracotta.connection.EndpointConnectorImpl;
import com.terracotta.connection.TerracottaConnection;
import com.terracotta.connection.TerracottaInternalClient;
import com.terracotta.connection.TerracottaInternalClientFactory;
import com.terracotta.connection.TerracottaInternalClientFactoryImpl;
import com.terracotta.connection.api.DetailedConnectionException;
import com.terracotta.connection.client.TerracottaClientConfigParams;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.stream.Collectors;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionService;

abstract class AbstractConnectionService
implements ConnectionService {
    private final String scheme;
    private final EndpointConnector endpointConnector;
    private final TerracottaInternalClientFactory clientFactory;

    AbstractConnectionService(String scheme) {
        this(scheme, new EndpointConnectorImpl(), new TerracottaInternalClientFactoryImpl());
    }

    AbstractConnectionService(String scheme, EndpointConnector endpointConnector, TerracottaInternalClientFactory clientFactory) {
        this.scheme = scheme;
        this.endpointConnector = endpointConnector;
        this.clientFactory = clientFactory;
    }

    @Override
    public boolean handlesURI(URI uri) {
        return this.handlesConnectionType(uri.getScheme());
    }

    @Override
    public boolean handlesConnectionType(String connectionType) {
        return this.scheme.equals(connectionType);
    }

    @Override
    public final Connection connect(URI uri, Properties properties) throws ConnectionException {
        String[] hosts;
        if (!this.handlesURI(uri)) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        TerracottaClientConfigParams clientConfig = new TerracottaClientConfigParams();
        for (String host : hosts = uri.getSchemeSpecificPart().split(",")) {
            URI oneHost;
            if (0 != host.indexOf("//")) {
                host = "//" + host;
            }
            try {
                oneHost = new URI(host).parseServerAuthority();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to parse uri " + uri, e);
            }
            int port = oneHost.getPort() < 0 ? 0 : oneHost.getPort();
            InetSocketAddress address = InetSocketAddress.createUnresolved(oneHost.getHost(), port);
            clientConfig.addStripeMember(address);
        }
        return this.createConnection(properties, clientConfig);
    }

    @Override
    public final Connection connect(Iterable<InetSocketAddress> servers, Properties properties) throws ConnectionException {
        String connectionType = properties.getProperty("connection.type", "terracotta");
        if (!this.handlesConnectionType(connectionType)) {
            throw new IllegalArgumentException("Unknown connectionType " + connectionType);
        }
        TerracottaClientConfigParams clientConfig = new TerracottaClientConfigParams();
        servers.forEach(clientConfig::addStripeMember);
        return this.createConnection(properties, clientConfig);
    }

    private Connection createConnection(Properties properties, TerracottaClientConfigParams clientConfig) throws DetailedConnectionException {
        properties.put("client.builder.type", (Object)ClientBuilderFactory.ClientBuilderType.of(this.scheme));
        clientConfig.addGenericProperties(properties);
        properties.put("connection", clientConfig.getStripeMemberUris().stream().map(i -> i.toString()).collect(Collectors.joining(", ")));
        TerracottaInternalClient client = this.clientFactory.createL1Client(clientConfig);
        client.init();
        return new TerracottaConnection(properties, client.getClientEntityManager(), this.endpointConnector, client::shutdown);
    }
}

