/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.factory;

import com.tc.util.io.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public abstract class AbstractFactory {
    public static AbstractFactory getFactory(String id, Class<?> defaultImpl) {
        String factoryClassName = AbstractFactory.findFactoryClassName(id);
        AbstractFactory factory = null;
        if (factoryClassName != null) {
            try {
                factory = (AbstractFactory)Class.forName(factoryClassName).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate '" + factoryClassName + "'", e);
            }
        }
        if (factory == null) {
            try {
                factory = (AbstractFactory)defaultImpl.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findFactoryClassName(String id) {
        InputStream is;
        block11: {
            BufferedReader rd;
            block10: {
                String string;
                String serviceId = "META-INF/services/" + id;
                is = null;
                try {
                    ClassLoader cl = AbstractFactory.class.getClassLoader();
                    if (cl != null) {
                        is = cl.getResourceAsStream(serviceId);
                    }
                    if (is != null) break block10;
                    string = System.getProperty(id);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly(is);
                return string;
            }
            try {
                rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            String factoryClassName = null;
            try {
                factoryClassName = rd.readLine();
                rd.close();
            }
            catch (IOException x) {
                String string = System.getProperty(id);
                IOUtils.closeQuietly(is);
                return string;
            }
            if (factoryClassName == null || "".equals(factoryClassName)) break block11;
            String string = factoryClassName;
            IOUtils.closeQuietly(is);
            return string;
        }
        String string = System.getProperty(id);
        IOUtils.closeQuietly(is);
        return string;
    }
}

