/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.object.StatType;
import com.tc.text.PrettyPrintable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InFlightStats
implements PrettyPrintable {
    private static final List<Combo> values = Arrays.asList(new Combo(StatType.CLIENT_ENCODE, StatType.CLIENT_SEND), new Combo(StatType.CLIENT_SEND, StatType.CLIENT_SENT), new Combo(StatType.CLIENT_SENT, StatType.CLIENT_RECEIVED), new Combo(StatType.CLIENT_RECEIVED, StatType.CLIENT_COMPLETE), new Combo(StatType.CLIENT_COMPLETE, StatType.CLIENT_GOT), new Combo(StatType.CLIENT_GOT, StatType.CLIENT_DECODED), new Combo(StatType.CLIENT_COMPLETE, StatType.CLIENT_RETIRED), new Combo(StatType.CLIENT_SENT, StatType.CLIENT_RETIRED), new Combo(StatType.CLIENT_ENCODE, StatType.CLIENT_DECODED), new Combo(StatType.SERVER_ADD, StatType.SERVER_SCHEDULE), new Combo(StatType.SERVER_SCHEDULE, StatType.SERVER_BEGININVOKE), new Combo(StatType.SERVER_BEGININVOKE, StatType.SERVER_ENDINVOKE), new Combo(StatType.SERVER_RECEIVED, StatType.SERVER_COMPLETE), new Combo(StatType.SERVER_COMPLETE, StatType.SERVER_RETIRED));
    private final LongAdder totalCount = new LongAdder();

    InFlightStats() {
    }

    public void collect(long[] input) {
        if (input != null) {
            values.forEach(c -> c.add(input));
        }
        this.totalCount.increment();
    }

    @Override
    public Map<String, ?> getStateMap() {
        LinkedHashMap map = new LinkedHashMap();
        if (this.totalCount.sum() > 0L) {
            values.forEach(c -> map.put(c.toString(), c.value() / this.totalCount.sum()));
        }
        return map;
    }

    static class Combo {
        Logger LOG = LoggerFactory.getLogger(Combo.class);
        private final StatType from;
        private final StatType to;
        private final LongAdder value = new LongAdder();

        Combo(StatType from, StatType to) {
            this.from = from;
            this.to = to;
        }

        Combo add(long[] vals) {
            try {
                this.value.add(vals[this.to.ordinal()] - vals[this.from.ordinal()]);
            }
            catch (Throwable t) {
                this.LOG.warn("error collecting stats", t);
            }
            return this;
        }

        long value() {
            return this.value.sum();
        }

        public String toString() {
            return this.from.description() + "->" + this.to.description();
        }
    }
}

