/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.StripeID;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.ConnectionIDFactoryListener;
import com.tc.util.Assert;
import com.tc.util.ProductID;
import java.util.concurrent.atomic.AtomicLong;

public class NullConnectionIDFactoryImpl
implements ConnectionIDFactory {
    private final AtomicLong cid = new AtomicLong(-2L);

    @Override
    public long getCurrentConnectionID() {
        return this.cid.get();
    }

    @Override
    public ConnectionID populateConnectionID(ConnectionID connectionID) {
        ProductID requested = connectionID.getProductId();
        switch (requested) {
            case DIAGNOSTIC: {
                break;
            }
            default: {
                requested = ProductID.INFORMATIONAL;
            }
        }
        ConnectionID connection = new ConnectionID(connectionID.getJvmID(), this.cid.decrementAndGet(), requested);
        Assert.assertTrue(!connection.isValid());
        return connection;
    }

    @Override
    public void registerForConnectionIDEvents(ConnectionIDFactoryListener listener) {
    }

    @Override
    public void activate(StripeID stripeID, long nextAvailChannelID) {
    }
}

