/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.setup;

import com.tc.config.schema.CommonL1Config;
import com.tc.config.schema.L2ConfigForL1;
import com.tc.config.schema.setup.L1ConfigurationSetupManager;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ClientConfigurationSetupManager
implements L1ConfigurationSetupManager {
    private final String[] args;
    private L2ConfigForL1.L2Data[] l2Data;
    private final String legacyStripeConfigText;

    public ClientConfigurationSetupManager(List<InetSocketAddress> stripeMemberUris, String[] args) {
        this.args = args;
        this.l2Data = new L2ConfigForL1.L2Data[stripeMemberUris.size()];
        for (int i = 0; i < this.l2Data.length; ++i) {
            this.l2Data[i] = new L2ConfigForL1.L2Data(stripeMemberUris.get(i), false);
        }
        String stripeText = null;
        for (InetSocketAddress member : stripeMemberUris) {
            if (null == stripeText) {
                stripeText = member.toString();
                continue;
            }
            stripeText = stripeText + "," + member;
        }
        this.legacyStripeConfigText = stripeText;
    }

    public void addServer(String host, int port) {
        this.l2Data = Arrays.copyOf(this.l2Data, this.l2Data.length + 1);
        this.l2Data[this.l2Data.length - 1] = new L2ConfigForL1.L2Data(InetSocketAddress.createUnresolved(host, port), false);
    }

    @Override
    public String[] processArguments() {
        return this.args;
    }

    @Override
    public boolean loadedFromTrustedSource() {
        return false;
    }

    @Override
    public String rawConfigText() {
        return this.legacyStripeConfigText;
    }

    @Override
    public String source() {
        return this.legacyStripeConfigText;
    }

    @Override
    public CommonL1Config commonL1Config() {
        return null;
    }

    @Override
    public L2ConfigForL1 l2Config() {
        return new L2ConfigForL1(){

            @Override
            public L2ConfigForL1.L2Data[] l2Data() {
                return ClientConfigurationSetupManager.this.l2Data;
            }
        };
    }

    @Override
    public Map<String, String> getOverrideTCProperties() {
        return Collections.emptyMap();
    }
}

