/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.ehcache.clustered.common.internal.messages.ChainCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.MessageCodecUtils;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.ehcache.clustered.common.internal.store.Chain;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class ServerStoreOpCodec {
    private static final Struct GET_AND_APPEND_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("key", 30).byteBuffer("payload", 40).build();
    private static final Struct APPEND_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("key", 30).byteBuffer("payload", 40).build();
    private static final Struct REPLACE_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("key", 30).struct("expect", 40, ChainCodec.CHAIN_STRUCT).struct("update", 50, ChainCodec.CHAIN_STRUCT).build();
    private static final Struct CLIENT_INVALIDATION_ACK_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("key", 20).int32("invalidationId", 30).build();
    private static final Struct CLIENT_INVALIDATION_ALL_ACK_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int32("invalidationId", 40).build();
    private static final Struct CLEAR_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).build();
    private static final Struct GET_MESSAGE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("key", 30).build();
    private static final Struct LOCK_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("hash", 30).build();
    private static final Struct ITERATOR_OPEN_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int32("batchSize", 20).build();
    private static final Struct ITERATOR_CLOSE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).string("id", 20).build();
    private static final Struct ITERATOR_ADVANCE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).string("id", 20).int32("batchSize", 30).build();

    public byte[] encode(ServerStoreOpMessage message) {
        switch (message.getMessageType()) {
            case GET_STORE: {
                ServerStoreOpMessage.GetMessage getMessage = (ServerStoreOpMessage.GetMessage)message;
                return ((StructEncoder)MessageCodecUtils.encodeMandatoryFields(GET_MESSAGE_STRUCT, message).int64("key", getMessage.getKey())).encode().array();
            }
            case APPEND: {
                ServerStoreOpMessage.AppendMessage appendMessage = (ServerStoreOpMessage.AppendMessage)message;
                return ((StructEncoder)((StructEncoder)MessageCodecUtils.encodeMandatoryFields(APPEND_MESSAGE_STRUCT, message).int64("key", appendMessage.getKey())).byteBuffer("payload", appendMessage.getPayload())).encode().array();
            }
            case GET_AND_APPEND: {
                ServerStoreOpMessage.GetAndAppendMessage getAndAppendMessage = (ServerStoreOpMessage.GetAndAppendMessage)message;
                return ((StructEncoder)((StructEncoder)MessageCodecUtils.encodeMandatoryFields(GET_AND_APPEND_MESSAGE_STRUCT, message).int64("key", getAndAppendMessage.getKey())).byteBuffer("payload", getAndAppendMessage.getPayload())).encode().array();
            }
            case REPLACE: {
                ServerStoreOpMessage.ReplaceAtHeadMessage replaceAtHeadMessage = (ServerStoreOpMessage.ReplaceAtHeadMessage)message;
                return ((StructEncoder)MessageCodecUtils.encodeMandatoryFields(REPLACE_MESSAGE_STRUCT, message).int64("key", replaceAtHeadMessage.getKey())).struct("expect", replaceAtHeadMessage.getExpect(), ChainCodec::encode).struct("update", replaceAtHeadMessage.getUpdate(), ChainCodec::encode).encode().array();
            }
            case CLIENT_INVALIDATION_ACK: {
                ServerStoreOpMessage.ClientInvalidationAck clientInvalidationAckMessage = (ServerStoreOpMessage.ClientInvalidationAck)message;
                return ((StructEncoder)((StructEncoder)MessageCodecUtils.encodeMandatoryFields(CLIENT_INVALIDATION_ACK_MESSAGE_STRUCT, message).int64("key", clientInvalidationAckMessage.getKey())).int32("invalidationId", clientInvalidationAckMessage.getInvalidationId())).encode().array();
            }
            case CLIENT_INVALIDATION_ALL_ACK: {
                ServerStoreOpMessage.ClientInvalidationAllAck clientInvalidationAllAckMessage = (ServerStoreOpMessage.ClientInvalidationAllAck)message;
                return ((StructEncoder)MessageCodecUtils.encodeMandatoryFields(CLIENT_INVALIDATION_ALL_ACK_MESSAGE_STRUCT, message).int32("invalidationId", clientInvalidationAllAckMessage.getInvalidationId())).encode().array();
            }
            case CLEAR: {
                return MessageCodecUtils.encodeMandatoryFields(CLEAR_MESSAGE_STRUCT, message).encode().array();
            }
            case LOCK: {
                ServerStoreOpMessage.LockMessage lockMessage = (ServerStoreOpMessage.LockMessage)message;
                return ((StructEncoder)MessageCodecUtils.encodeMandatoryFields(LOCK_STRUCT, message).int64("hash", lockMessage.getHash())).encode().array();
            }
            case UNLOCK: {
                ServerStoreOpMessage.UnlockMessage unlockMessage = (ServerStoreOpMessage.UnlockMessage)message;
                return ((StructEncoder)MessageCodecUtils.encodeMandatoryFields(LOCK_STRUCT, message).int64("hash", unlockMessage.getHash())).encode().array();
            }
            case ITERATOR_OPEN: {
                return ((StructEncoder)MessageCodecUtils.encodeMandatoryFields(ITERATOR_OPEN_STRUCT, message).int32("batchSize", ((ServerStoreOpMessage.IteratorOpenMessage)message).getBatchSize())).encode().array();
            }
            case ITERATOR_CLOSE: {
                return ((StructEncoder)MessageCodecUtils.encodeMandatoryFields(ITERATOR_CLOSE_STRUCT, message).string("id", ((ServerStoreOpMessage.IteratorCloseMessage)message).getIdentity().toString())).encode().array();
            }
            case ITERATOR_ADVANCE: {
                return ((StructEncoder)((StructEncoder)MessageCodecUtils.encodeMandatoryFields(ITERATOR_ADVANCE_STRUCT, message).string("id", ((ServerStoreOpMessage.IteratorAdvanceMessage)message).getIdentity().toString())).int32("batchSize", ((ServerStoreOpMessage.IteratorAdvanceMessage)message).getBatchSize())).encode().array();
            }
        }
        throw new RuntimeException("Unhandled message operation : " + (Object)((Object)message.getMessageType()));
    }

    public EhcacheEntityMessage decode(EhcacheMessageType opCode, ByteBuffer messageBuffer) {
        switch (opCode) {
            case GET_STORE: {
                StructDecoder<Void> decoder = GET_MESSAGE_STRUCT.decoder(messageBuffer);
                Long key = decoder.int64("key");
                return new ServerStoreOpMessage.GetMessage(key);
            }
            case GET_AND_APPEND: {
                StructDecoder<Void> decoder = GET_AND_APPEND_MESSAGE_STRUCT.decoder(messageBuffer);
                Long key = decoder.int64("key");
                ByteBuffer payload = decoder.byteBuffer("payload");
                return new ServerStoreOpMessage.GetAndAppendMessage(key, payload);
            }
            case APPEND: {
                StructDecoder<Void> decoder = APPEND_MESSAGE_STRUCT.decoder(messageBuffer);
                Long key = decoder.int64("key");
                ByteBuffer payload = decoder.byteBuffer("payload");
                return new ServerStoreOpMessage.AppendMessage(key, payload);
            }
            case REPLACE: {
                StructDecoder<Void> decoder = REPLACE_MESSAGE_STRUCT.decoder(messageBuffer);
                Long key = decoder.int64("key");
                Chain expect = ChainCodec.decode(decoder.struct("expect"));
                Chain update = ChainCodec.decode(decoder.struct("update"));
                return new ServerStoreOpMessage.ReplaceAtHeadMessage(key, expect, update);
            }
            case CLIENT_INVALIDATION_ACK: {
                StructDecoder<Void> decoder = CLIENT_INVALIDATION_ACK_MESSAGE_STRUCT.decoder(messageBuffer);
                Long key = decoder.int64("key");
                Integer invalidationId = decoder.int32("invalidationId");
                return new ServerStoreOpMessage.ClientInvalidationAck(key, invalidationId);
            }
            case CLIENT_INVALIDATION_ALL_ACK: {
                StructDecoder<Void> decoder = CLIENT_INVALIDATION_ALL_ACK_MESSAGE_STRUCT.decoder(messageBuffer);
                Integer invalidationId = decoder.int32("invalidationId");
                return new ServerStoreOpMessage.ClientInvalidationAllAck(invalidationId);
            }
            case CLEAR: {
                return new ServerStoreOpMessage.ClearMessage();
            }
            case LOCK: {
                StructDecoder<Void> decoder = LOCK_STRUCT.decoder(messageBuffer);
                long hash = decoder.int64("hash");
                return new ServerStoreOpMessage.LockMessage(hash);
            }
            case UNLOCK: {
                StructDecoder<Void> decoder = LOCK_STRUCT.decoder(messageBuffer);
                long hash = decoder.int64("hash");
                return new ServerStoreOpMessage.UnlockMessage(hash);
            }
            case ITERATOR_OPEN: {
                StructDecoder<Void> decoder = ITERATOR_OPEN_STRUCT.decoder(messageBuffer);
                int batchSize = decoder.int32("batchSize");
                return new ServerStoreOpMessage.IteratorOpenMessage(batchSize);
            }
            case ITERATOR_CLOSE: {
                StructDecoder<Void> decoder = ITERATOR_CLOSE_STRUCT.decoder(messageBuffer);
                UUID identity = UUID.fromString(decoder.string("id"));
                return new ServerStoreOpMessage.IteratorCloseMessage(identity);
            }
            case ITERATOR_ADVANCE: {
                StructDecoder<Void> decoder = ITERATOR_ADVANCE_STRUCT.decoder(messageBuffer);
                UUID identity = UUID.fromString(decoder.string("id"));
                int batchSize = decoder.int32("batchSize");
                return new ServerStoreOpMessage.IteratorAdvanceMessage(identity, batchSize);
            }
        }
        throw new RuntimeException("Unhandled message operation : " + (Object)((Object)opCode));
    }
}

