/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection;

import com.tc.net.protocol.transport.ClientConnectionErrorDetails;
import com.tc.object.ClientBuilder;
import com.tc.object.ClientBuilderFactory;
import com.tc.object.ClientEntityManager;
import com.tc.object.DistributedObjectClient;
import com.tc.object.DistributedObjectClientFactory;
import com.terracotta.connection.ClientHandle;
import com.terracotta.connection.ClientHandleImpl;
import com.terracotta.connection.TerracottaInternalClient;
import com.terracotta.connection.api.DetailedConnectionException;
import com.terracotta.connection.client.TerracottaClientStripeConnectionConfig;
import java.util.Properties;
import java.util.concurrent.TimeoutException;

public class TerracottaInternalClientImpl
implements TerracottaInternalClient {
    private final DistributedObjectClientFactory clientCreator;
    private final ClientConnectionErrorDetails errorListener = new ClientConnectionErrorDetails();
    private volatile ClientHandle clientHandle;
    private volatile boolean shutdown = false;
    private volatile boolean isInitialized = false;

    TerracottaInternalClientImpl(TerracottaClientStripeConnectionConfig stripeConnectionConfig, Properties props) {
        try {
            this.clientCreator = this.buildClientCreator(stripeConnectionConfig, props);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DistributedObjectClientFactory buildClientCreator(TerracottaClientStripeConnectionConfig stripeConnectionConfig, Properties props) {
        ClientBuilder clientBuilder = ClientBuilderFactory.get().create(props);
        clientBuilder.setClientConnectionErrorListener(this.errorListener);
        return new DistributedObjectClientFactory(stripeConnectionConfig.getStripeMemberUris(), clientBuilder, props);
    }

    @Override
    public synchronized void init() throws DetailedConnectionException {
        block7: {
            if (this.isInitialized) {
                return;
            }
            DistributedObjectClient client = null;
            this.errorListener.attachCollector();
            try {
                try {
                    client = this.clientCreator.create();
                }
                catch (Exception e) {
                    throw new DetailedConnectionException(new Exception(DetailedConnectionException.getDetailedMessage(this.errorListener.getErrors()), e), this.errorListener.getErrors());
                }
                if (client != null) {
                    this.clientHandle = new ClientHandleImpl(client);
                    this.isInitialized = true;
                    break block7;
                }
                TimeoutException e = new TimeoutException(DetailedConnectionException.getDetailedMessage(this.errorListener.getErrors()));
                throw new DetailedConnectionException(e, this.errorListener.getErrors());
            }
            finally {
                this.errorListener.removeCollector();
            }
        }
    }

    @Override
    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public synchronized void shutdown() {
        this.shutdown = true;
        try {
            if (this.clientHandle != null) {
                this.clientHandle.shutdown();
            }
        }
        finally {
            this.clientHandle = null;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public ClientEntityManager getClientEntityManager() {
        return this.clientHandle.getClientEntityManager();
    }

    static class ClientShutdownException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ClientShutdownException() {
        }
    }
}

