/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.net.TCSocketAddress;
import com.tc.net.core.TCListener;
import com.tc.net.protocol.tcm.ChannelManager;
import com.tc.net.protocol.tcm.ChannelManagerImpl;
import com.tc.net.protocol.tcm.CommunicationsManagerImpl;
import com.tc.net.protocol.tcm.NetworkListener;
import com.tc.net.protocol.tcm.TCMessageFactory;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.ConnectionIDFactory;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.WireProtocolMessageSink;
import com.tc.operatorevent.NodeNameProvider;
import com.tc.util.TCTimeoutException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Set;
import java.util.function.Predicate;

class NetworkListenerImpl
implements NetworkListener {
    private final ChannelManagerImpl channelManager;
    private final CommunicationsManagerImpl commsMgr;
    private final TCSocketAddress addr;
    private TCListener lsnr;
    private boolean started;
    private final boolean reuseAddr;
    private final ConnectionIDFactory connectionIdFactory;
    private final WireProtocolMessageSink wireProtoMsgSnk;
    private final NodeNameProvider activeProvider;
    private final Predicate<MessageTransport> validation;

    NetworkListenerImpl(TCSocketAddress addr, CommunicationsManagerImpl commsMgr, ChannelManagerImpl channelManager, TCMessageFactory msgFactory, boolean reuseAddr, ConnectionIDFactory connectionIdFactory, WireProtocolMessageSink wireProtoMsgSnk, NodeNameProvider activeProvider, Predicate<MessageTransport> validation) {
        this.commsMgr = commsMgr;
        this.channelManager = channelManager;
        this.addr = addr;
        this.connectionIdFactory = connectionIdFactory;
        this.wireProtoMsgSnk = wireProtoMsgSnk;
        this.started = false;
        this.reuseAddr = reuseAddr;
        this.activeProvider = activeProvider;
        this.validation = validation;
    }

    @Override
    public synchronized void start(Set<ConnectionID> initialConnectionIDs) throws IOException {
        this.lsnr = this.commsMgr.createCommsListener(this.addr, this.channelManager, this.reuseAddr, initialConnectionIDs, this.activeProvider, this.validation, this.connectionIdFactory, this.wireProtoMsgSnk);
        this.started = true;
        this.commsMgr.registerListener(this);
    }

    @Override
    public synchronized void stop(long timeout) throws TCTimeoutException {
        if (!this.started) {
            return;
        }
        try {
            if (this.lsnr != null) {
                this.lsnr.stop(timeout);
            }
        }
        finally {
            this.started = false;
            this.commsMgr.unregisterListener(this);
        }
    }

    @Override
    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    @Override
    public synchronized InetAddress getBindAddress() {
        if (!this.started) {
            throw new IllegalStateException("Listener not running");
        }
        return this.lsnr.getBindAddress();
    }

    @Override
    public synchronized int getBindPort() {
        if (!this.started) {
            throw new IllegalStateException("Listener not running");
        }
        return this.lsnr.getBindPort();
    }

    public String toString() {
        try {
            return this.getBindAddress().getHostAddress() + ":" + this.getBindPort();
        }
        catch (Exception e) {
            return "Exception in toString(): " + e.getMessage();
        }
    }
}

