/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.repository;

import com.tc.config.schema.repository.BeanRepository;

public class MockBeanRepository
implements BeanRepository {
    private int numEnsureBeanIsOfClasses;
    private Class<?> lastClass;
    private RuntimeException exceptionOnEnsureBeanIsOfClass = null;
    private int numBeans;
    private Object returnedBean = null;
    private int numSetBeans;
    private Object lastSetBean;
    private String lastSourceDescription;

    public MockBeanRepository() {
        this.reset();
    }

    public void reset() {
        this.numEnsureBeanIsOfClasses = 0;
        this.lastClass = null;
        this.numBeans = 0;
        this.numSetBeans = 0;
        this.lastSetBean = null;
        this.lastSourceDescription = null;
    }

    public void setExceptionOnEnsureBeanIsOfClass(RuntimeException exceptionOnEnsureBeanIsOfClass) {
        this.exceptionOnEnsureBeanIsOfClass = exceptionOnEnsureBeanIsOfClass;
    }

    @Override
    public void ensureBeanIsOfClass(Class<?> theClass) {
        ++this.numEnsureBeanIsOfClasses;
        this.lastClass = theClass;
        if (this.exceptionOnEnsureBeanIsOfClass != null) {
            throw this.exceptionOnEnsureBeanIsOfClass;
        }
    }

    @Override
    public Object bean() {
        ++this.numBeans;
        return this.returnedBean;
    }

    public Object getLastSetBean() {
        return this.lastSetBean;
    }

    public String getLastSourceDescription() {
        return this.lastSourceDescription;
    }

    public int getNumBeans() {
        return this.numBeans;
    }

    public int getNumSetBeans() {
        return this.numSetBeans;
    }

    public void setReturnedBean(Object returnedBean) {
        this.returnedBean = returnedBean;
    }

    public Class<?> getLastClass() {
        return this.lastClass;
    }

    public int getNumEnsureBeanIsOfClasses() {
        return this.numEnsureBeanIsOfClasses;
    }

    @Override
    public void setBean(Object bean, String description) {
        throw new UnsupportedOperationException();
    }
}

