/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store.lock;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.store.ClusterTierClientEntity;
import org.ehcache.clustered.client.internal.store.ServerStoreProxyException;
import org.ehcache.clustered.client.internal.store.lock.LockManager;
import org.ehcache.clustered.common.internal.messages.ClusterTierReconnectMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheResponseType;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;

public class LockManagerImpl
implements LockManager {
    private final ClusterTierClientEntity clientEntity;
    private final Set<Long> locksHeld = Collections.newSetFromMap(new ConcurrentHashMap());

    public LockManagerImpl(ClusterTierClientEntity clientEntity) {
        this.clientEntity = clientEntity;
        clientEntity.addReconnectListener(this::reconnectListener);
    }

    private void reconnectListener(ClusterTierReconnectMessage reconnectMessage) {
        reconnectMessage.addLocksHeld(this.locksHeld);
    }

    @Override
    public Chain lock(long hash) throws TimeoutException {
        EhcacheEntityResponse.LockSuccess response = this.getlockResponse(hash);
        this.locksHeld.add(hash);
        return response.getChain();
    }

    private EhcacheEntityResponse.LockSuccess getlockResponse(long hash) throws TimeoutException {
        EhcacheEntityResponse response;
        do {
            try {
                response = this.clientEntity.invokeAndWaitForComplete(new ServerStoreOpMessage.LockMessage(hash), false);
            }
            catch (TimeoutException tme) {
                throw tme;
            }
            catch (Exception e) {
                throw new ServerStoreProxyException(e);
            }
            if (response != null) continue;
            throw new ServerStoreProxyException("Response for acquiring lock was invalid null message");
        } while (response.getResponseType() == EhcacheResponseType.LOCK_FAILURE);
        return (EhcacheEntityResponse.LockSuccess)response;
    }

    @Override
    public void unlock(long hash) throws TimeoutException {
        try {
            this.clientEntity.invokeAndWaitForComplete(new ServerStoreOpMessage.UnlockMessage(hash), false);
            this.locksHeld.remove(hash);
        }
        catch (TimeoutException tme) {
            throw tme;
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
    }
}

