/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.config;

import org.ehcache.clustered.client.config.ClusteredResourcePool;
import org.ehcache.clustered.client.config.DedicatedClusteredResourcePool;
import org.ehcache.clustered.client.config.SharedClusteredResourcePool;
import org.ehcache.config.ResourceType;

public interface ClusteredResourceType<P extends ClusteredResourcePool>
extends ResourceType<P> {

    public static final class Types {
        public static final ClusteredResourceType<DedicatedClusteredResourcePool> DEDICATED = new BaseClusteredResourceType<DedicatedClusteredResourcePool>("DEDICATED", DedicatedClusteredResourcePool.class);
        public static final ClusteredResourceType<SharedClusteredResourcePool> SHARED = new BaseClusteredResourceType<SharedClusteredResourcePool>("SHARED", SharedClusteredResourcePool.class);
        public static final ClusteredResourceType<ClusteredResourcePool> UNKNOWN = new BaseClusteredResourceType<ClusteredResourcePool>("UNKNOWN", ClusteredResourcePool.class);

        public static ClusteredResourceType<? extends ClusteredResourcePool>[] values() {
            return new ClusteredResourceType[]{DEDICATED, SHARED, UNKNOWN};
        }

        private static final class BaseClusteredResourceType<P extends ClusteredResourcePool>
        implements ClusteredResourceType<P> {
            private final String name;
            private final Class<P> resourcePoolClass;

            private BaseClusteredResourceType(String name, Class<P> resourcePoolClass) {
                this.name = name;
                this.resourcePoolClass = resourcePoolClass;
            }

            @Override
            public Class<P> getResourcePoolClass() {
                return this.resourcePoolClass;
            }

            @Override
            public boolean isPersistable() {
                return true;
            }

            @Override
            public boolean requiresSerialization() {
                return true;
            }

            @Override
            public int getTierHeight() {
                return 10;
            }

            public String toString() {
                return "clustered-" + this.name.toLowerCase();
            }
        }
    }
}

