/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;

public class PipeSocket
extends Socket {
    private final Pipe inputPipe;
    private final Pipe outputPipe;
    private final Socket socket;
    private volatile boolean closed = false;

    public PipeSocket(Socket socket) throws IOException {
        this.socket = socket;
        this.inputPipe = Pipe.open();
        this.outputPipe = Pipe.open();
        this.outputPipe.source().configureBlocking(false);
    }

    public Pipe.SourceChannel getOutputPipeSourceChannel() {
        return this.outputPipe.source();
    }

    public Pipe.SinkChannel getInputPipeSinkChannel() {
        return this.inputPipe.sink();
    }

    @Override
    public InputStream getInputStream() {
        return Channels.newInputStream(this.inputPipe.source());
    }

    @Override
    public OutputStream getOutputStream() {
        return new PipeSocketOutputStream(Channels.newOutputStream(this.outputPipe.sink()));
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        if (this.closed) {
            return null;
        }
        return this.socket.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        if (this.closed) {
            return null;
        }
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.closed) {
            return null;
        }
        return this.socket.getLocalAddress();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.closed = true;
        this.closeRead();
        this.closeWrite();
    }

    public void dispose() throws IOException {
        if (!this.isClosed()) {
            this.close();
        }
    }

    public void onWrite() {
    }

    public void closeRead() throws IOException {
        this.inputPipe.sink().close();
        this.inputPipe.source().close();
    }

    public void closeWrite() throws IOException {
        this.outputPipe.sink().close();
        this.outputPipe.source().close();
    }

    private final class PipeSocketOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        PipeSocketOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
            PipeSocket.this.onWrite();
        }
    }
}

