/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.delivery;

import com.tc.bytes.TCByteBuffer;
import com.tc.net.protocol.TCProtocolException;
import com.tc.net.protocol.delivery.OOOProtocolMessage;
import com.tc.net.protocol.delivery.OOOProtocolMessageFactory;
import com.tc.net.protocol.delivery.OOOProtocolMessageHeader;
import com.tc.util.Assert;

class OOOProtocolMessageParser {
    private final OOOProtocolMessageFactory messageFactory;

    public OOOProtocolMessageParser(OOOProtocolMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public OOOProtocolMessage parseMessage(TCByteBuffer[] data) throws TCProtocolException {
        TCByteBuffer[] msgData;
        int hdrLength = OOOProtocolMessageHeader.HEADER_LENGTH;
        if (hdrLength > data[0].limit()) {
            throw new TCProtocolException("header not contained in first buffer: " + hdrLength + " > " + data[0].limit());
        }
        OOOProtocolMessageHeader header = new OOOProtocolMessageHeader(data[0].duplicate().limit(OOOProtocolMessageHeader.HEADER_LENGTH));
        header.validate();
        if (header.getHeaderByteLength() < data[0].limit()) {
            msgData = new TCByteBuffer[data.length];
            System.arraycopy(data, 0, msgData, 0, msgData.length);
            TCByteBuffer firstPayloadBuffer = msgData[0].duplicate();
            firstPayloadBuffer.position(header.getHeaderByteLength());
            msgData[0] = firstPayloadBuffer.slice();
        } else {
            Assert.eval(data.length >= 1);
            msgData = new TCByteBuffer[data.length - 1];
            System.arraycopy(data, 1, msgData, 0, msgData.length);
        }
        return this.messageFactory.createNewMessage(header, msgData);
    }
}

