/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.terracotta.context.WeakIdentityHashMap;
import org.terracotta.context.annotations.ContextAttribute;
import org.terracotta.statistics.StatisticType;
import org.terracotta.statistics.ValueStatistic;

@ContextAttribute(value="this")
class PassThroughStatistic<T extends Serializable>
implements ValueStatistic<T> {
    private static final WeakIdentityHashMap<Object, Collection<PassThroughStatistic<? extends Serializable>>> BINDING = new WeakIdentityHashMap();
    @ContextAttribute(value="name")
    public final String name;
    @ContextAttribute(value="tags")
    public final Set<String> tags;
    @ContextAttribute(value="properties")
    public final Map<String, Object> properties;
    @ContextAttribute(value="type")
    public final StatisticType type;
    private final ValueStatistic<T> source;

    private static void bindStatistic(PassThroughStatistic<? extends Serializable> stat, Object to) {
        Collection<PassThroughStatistic<? extends Serializable>> racer;
        Collection<PassThroughStatistic<? extends Serializable>> collection = BINDING.get(to);
        if (collection == null && (racer = BINDING.putIfAbsent(to, collection = new CopyOnWriteArrayList<PassThroughStatistic<? extends Serializable>>())) != null) {
            collection = racer;
        }
        collection.add(stat);
    }

    public static void removeStatistics(Object to) {
        BINDING.remove(to);
    }

    static boolean hasStatisticsFor(Object to) {
        return BINDING.get(to) != null;
    }

    public PassThroughStatistic(Object context, String name, Set<String> tags, Map<String, ? extends Object> properties, ValueStatistic<T> source) {
        this.name = name;
        this.tags = Collections.unmodifiableSet(new HashSet<String>(tags));
        this.properties = Collections.unmodifiableMap(new HashMap<String, Object>(properties));
        this.source = source;
        this.type = source.type();
        PassThroughStatistic.bindStatistic(this, context);
    }

    @Override
    public T value() {
        return this.source.value();
    }

    @Override
    public StatisticType type() {
        return this.type;
    }
}

