/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.util.Assert;
import java.io.Serializable;
import java.net.InetSocketAddress;

public class ConnectionInfo
implements Serializable {
    public static final ConnectionInfo[] EMPTY_ARRAY = new ConnectionInfo[0];
    private final InetSocketAddress address;
    private final int server;

    public ConnectionInfo(String hostname, int port) {
        this(hostname, port, 0);
    }

    public ConnectionInfo(String hostname, int port, int server) {
        Assert.assertNotNull(hostname);
        Assert.assertTrue(port >= 0);
        this.address = InetSocketAddress.createUnresolved(hostname, port);
        this.server = server;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public String getHostname() {
        return this.address.getHostString();
    }

    public int getPort() {
        return this.address.getPort();
    }

    public int getServer() {
        return this.server;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConnectionInfo) {
            ConnectionInfo other = (ConnectionInfo)o;
            return this.address.equals(other.getAddress());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.address.toString();
    }
}

