/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.protocol.transport.MessageTransportState;
import com.tc.util.Assert;
import org.slf4j.Logger;

class MessageTransportStatus {
    private final MessageTransportState initial;
    private MessageTransportState state;
    private final Logger logger;
    private volatile boolean isEstablished = false;

    MessageTransportStatus(MessageTransportState initialState, Logger logger) {
        this.initial = initialState;
        this.state = initialState;
        this.logger = logger;
    }

    void reset() {
        this.stateChange(this.initial);
    }

    private synchronized void stateChange(MessageTransportState newState) {
        this.isEstablished = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Changing from " + this.state.toString() + " to " + newState.toString());
        }
        if (this.isEnd()) {
            Assert.eval("Transport StateChange from END state not allowed", newState == MessageTransportState.STATE_START || newState != MessageTransportState.STATE_END);
            this.logger.warn("Unexpected Transport StateChange attempt. Changing from " + this.state.toString() + " to " + newState.toString(), new Throwable());
        }
        this.state = newState;
        this.notifyAll();
    }

    void synSent() {
        this.stateChange(MessageTransportState.STATE_SYN_SENT);
    }

    void synAckError() {
        this.stateChange(MessageTransportState.STATE_SYN_ACK_ERROR);
    }

    void established() {
        this.stateChange(MessageTransportState.STATE_ESTABLISHED);
    }

    void closed() {
        this.stateChange(MessageTransportState.STATE_CLOSED);
    }

    void connected() {
        this.stateChange(MessageTransportState.STATE_CONNECTED);
    }

    void disconnect() {
        this.stateChange(MessageTransportState.STATE_DISCONNECTED);
    }

    void end() {
        this.stateChange(MessageTransportState.STATE_END);
    }

    private synchronized boolean checkState(MessageTransportState check) {
        if (check == MessageTransportState.STATE_ESTABLISHED && this.state == MessageTransportState.STATE_ESTABLISHED) {
            this.isEstablished = true;
        }
        return this.state.equals((Object)check);
    }

    boolean isStart() {
        return this.checkState(MessageTransportState.STATE_START);
    }

    boolean isStartOpen() {
        return this.checkState(MessageTransportState.STATE_START_OPEN);
    }

    boolean isRestart() {
        return this.checkState(MessageTransportState.STATE_RESTART);
    }

    boolean isSynSent() {
        return this.checkState(MessageTransportState.STATE_SYN_SENT);
    }

    boolean isEstablished() {
        if (this.isEstablished) {
            return true;
        }
        return this.checkState(MessageTransportState.STATE_ESTABLISHED);
    }

    boolean isDisconnected() {
        return this.checkState(MessageTransportState.STATE_DISCONNECTED);
    }

    boolean isClosed() {
        return this.checkState(MessageTransportState.STATE_CLOSED);
    }

    boolean isConnected() {
        return this.checkState(MessageTransportState.STATE_CONNECTED);
    }

    synchronized boolean isEnd() {
        return this.checkState(MessageTransportState.STATE_END);
    }

    synchronized boolean isOpen() {
        return this.state.isOpen();
    }

    public String toString() {
        return this.state.toString();
    }
}

