/*
 * Decompiled with CFR 0.152.
 */
package com.tc.stats;

import java.util.LinkedList;

public class LossyStack<T> {
    private final LinkedList<T> data = new LinkedList();
    private final int maxDepth;

    public LossyStack(int depth) {
        if (depth < 1) {
            throw new IllegalArgumentException("stack depth must be greater than or equal to 1");
        }
        this.maxDepth = depth;
    }

    public synchronized void push(T obj) {
        this.data.addFirst(obj);
        if (this.data.size() > this.maxDepth) {
            this.data.removeLast();
        }
    }

    public synchronized T pop() {
        if (this.data.isEmpty()) {
            throw new IllegalStateException("stack empty");
        }
        return this.data.removeFirst();
    }

    public synchronized T[] toArray(T[] type) {
        return this.data.toArray(type);
    }

    public synchronized T peek() {
        if (this.data.isEmpty()) {
            return null;
        }
        return this.data.getFirst();
    }

    public synchronized boolean isEmtpy() {
        return this.data.isEmpty();
    }

    public synchronized int depth() {
        return this.data.size();
    }
}

