/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.protocol.transport.ClientConnectionEstablisher;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportListener;

public class ConnectionWatcher
implements MessageTransportListener {
    protected final ClientMessageTransport cmt;
    protected final ClientConnectionEstablisher cce;
    protected final MessageTransportListener target;

    public ConnectionWatcher(ClientMessageTransport cmt, MessageTransportListener target, ClientConnectionEstablisher cce) {
        this.cmt = cmt;
        this.target = target;
        this.cce = cce;
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
        this.cce.quitReconnectAttempts();
        this.target.notifyTransportClosed(transport);
    }

    @Override
    public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        if (transport.getConnectionId().getProductId().isReconnectEnabled()) {
            this.cce.asyncReconnect(this.cmt);
        } else {
            transport.close();
        }
        this.target.notifyTransportDisconnected(transport, forcedDisconnect);
    }

    @Override
    public void notifyTransportConnectAttempt(MessageTransport transport) {
        this.target.notifyTransportConnectAttempt(transport);
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
        this.target.notifyTransportConnected(transport);
    }

    @Override
    public void notifyTransportReconnectionRejected(MessageTransport transport) {
        this.target.notifyTransportReconnectionRejected(transport);
    }
}

