/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease;

import java.util.concurrent.TimeUnit;
import org.terracotta.lease.TimeSource;

public class TestTimeSource
implements TimeSource {
    private volatile long time = 1L;

    public void tickNanos(long increment) {
        this.time += increment;
    }

    public void tickMillis(long increment) {
        this.time += TimeUnit.NANOSECONDS.convert(increment, TimeUnit.MILLISECONDS);
    }

    @Override
    public long nanoTime() {
        return this.time;
    }

    @Override
    public void sleep(long milliseconds) throws InterruptedException {
        long now = this.time;
        long end = now + TimeUnit.NANOSECONDS.convert(milliseconds, TimeUnit.MILLISECONDS);
        while (this.time - end < 0L) {
            Thread.sleep(10L);
        }
    }
}

