/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection;

import com.tc.object.ClientEntityManager;
import com.terracotta.connection.EndpointConnector;
import com.terracotta.connection.EndpointConnectorImpl;
import com.terracotta.connection.EntityClientServiceFactory;
import com.terracotta.connection.entity.TerracottaEntityRef;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.terracotta.connection.Connection;
import org.terracotta.connection.entity.Entity;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.entity.EntityClientService;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.exception.ConnectionShutdownException;
import org.terracotta.exception.EntityNotProvidedException;

public class TerracottaConnection
implements Connection {
    private final ClientEntityManager entityManager;
    private final EntityClientServiceFactory factory = new EntityClientServiceFactory();
    private final EndpointConnector endpointConnector;
    private final Runnable shutdown;
    private final ConcurrentMap<Class<? extends Entity>, EntityClientService<?, ?, ? extends EntityMessage, ? extends EntityResponse, ?>> cachedEntityServices = new ConcurrentHashMap();
    private final AtomicLong clientIds = new AtomicLong(1L);
    private boolean isShutdown = false;

    public TerracottaConnection(ClientEntityManager entityManager, Runnable shutdown) {
        this(entityManager, new EndpointConnectorImpl(), shutdown);
    }

    public TerracottaConnection(ClientEntityManager entityManager, EndpointConnector endpointConnector, Runnable shutdown) {
        this.entityManager = entityManager;
        this.endpointConnector = endpointConnector;
        this.shutdown = shutdown;
    }

    @Override
    public synchronized <T extends Entity, C, U> EntityRef<T, C, U> getEntityRef(Class<T> cls, long version, String name) throws EntityNotProvidedException {
        this.checkShutdown();
        EntityClientService<T, ?, EntityMessage, EntityResponse, U> service = this.getEntityService(cls);
        if (null == service) {
            throw new EntityNotProvidedException(cls.getName(), name);
        }
        return new TerracottaEntityRef(this.entityManager, this.endpointConnector, cls, version, name, service, this.clientIds);
    }

    private <T extends Entity, U> EntityClientService<T, ?, ? extends EntityMessage, ? extends EntityResponse, U> getEntityService(Class<T> entityClass) {
        EntityClientService service = (EntityClientService)this.cachedEntityServices.get(entityClass);
        if (service == null && null != (service = this.factory.creationServiceForType(entityClass))) {
            EntityClientService tmp = this.cachedEntityServices.putIfAbsent(entityClass, service);
            service = tmp == null ? service : tmp;
        }
        return service;
    }

    @Override
    public synchronized void close() {
        this.checkShutdown();
        this.shutdown.run();
        this.isShutdown = true;
    }

    private void checkShutdown() {
        if (this.isShutdown) {
            throw new ConnectionShutdownException("Already shut down");
        }
    }

    private static class EntityKey<T extends Entity> {
        private final Class<T> cls;
        private final String name;

        private EntityKey(Class<T> cls, String name) {
            this.cls = cls;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntityKey entityKey = (EntityKey)o;
            if (!this.cls.equals(entityKey.cls)) {
                return false;
            }
            return this.name.equals(entityKey.name);
        }

        public int hashCode() {
            int result = this.cls.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

