/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.HashSet;
import org.ehcache.clustered.common.internal.messages.ClusterTierReconnectMessage;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.ArrayDecoder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.ArrayEncoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class ReconnectMessageCodec {
    private static final String HASH_INVALIDATION_IN_PROGRESS_FIELD = "hashInvalidationInProgress";
    private static final String CLEAR_IN_PROGRESS_FIELD = "clearInProgress";
    private static final Struct CLUSTER_TIER_RECONNECT_MESSAGE_STRUCT = StructBuilder.newStructBuilder().int64s("hashInvalidationInProgress", 20).bool("clearInProgress", 30).build();

    public byte[] encode(ClusterTierReconnectMessage reconnectMessage) {
        StructEncoder<Void> encoder = CLUSTER_TIER_RECONNECT_MESSAGE_STRUCT.encoder();
        ArrayEncoder<Long, StructEncoder<Void>> arrayEncoder = encoder.int64s(HASH_INVALIDATION_IN_PROGRESS_FIELD);
        for (Long hash : reconnectMessage.getInvalidationsInProgress()) {
            arrayEncoder.value(hash);
        }
        encoder.bool(CLEAR_IN_PROGRESS_FIELD, reconnectMessage.isClearInProgress());
        return encoder.encode().array();
    }

    public ClusterTierReconnectMessage decode(byte[] payload) {
        HashSet<Long> hashes;
        StructDecoder<Void> decoder = CLUSTER_TIER_RECONNECT_MESSAGE_STRUCT.decoder(ByteBuffer.wrap(payload));
        ArrayDecoder<Long, StructDecoder<Void>> arrayDecoder = decoder.int64s(HASH_INVALIDATION_IN_PROGRESS_FIELD);
        if (arrayDecoder != null) {
            hashes = new HashSet(arrayDecoder.length());
            for (int i = 0; i < arrayDecoder.length(); ++i) {
                hashes.add(arrayDecoder.value());
            }
        } else {
            hashes = new HashSet<Long>(0);
        }
        ClusterTierReconnectMessage message = new ClusterTierReconnectMessage(hashes);
        Boolean clearInProgress = decoder.bool(CLEAR_IN_PROGRESS_FIELD);
        if (clearInProgress != null && clearInProgress.booleanValue()) {
            message.clearInProgress();
        }
        return message;
    }
}

