/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.io;

import com.tc.security.TCAuthenticationException;
import com.tc.security.TCAuthorizationException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerURL {
    private static final Logger logger = LoggerFactory.getLogger(ServerURL.class);
    private final URL theURL;
    private final int timeout;

    public ServerURL(String host, int port, String file) throws MalformedURLException {
        this(host, port, file, -1);
    }

    public ServerURL(String host, int port, String file, int timeout) throws MalformedURLException {
        this.timeout = timeout;
        this.theURL = new URL("http", host, port, file);
    }

    public InputStream openStream() throws IOException {
        URLConnection urlConnection = this.createConnection();
        try {
            return urlConnection.getInputStream();
        }
        catch (IOException e) {
            if (urlConnection instanceof HttpURLConnection) {
                int responseCode = ((HttpURLConnection)urlConnection).getResponseCode();
                switch (responseCode) {
                    case 401: {
                        throw new TCAuthenticationException("Authentication error connecting to " + urlConnection.getURL(), e);
                    }
                    case 403: {
                        throw new TCAuthorizationException("Authorization error connecting to " + urlConnection.getURL(), e);
                    }
                }
            }
            throw e;
        }
    }

    private URLConnection createConnection() {
        URLConnection urlConnection;
        try {
            urlConnection = this.theURL.openConnection();
        }
        catch (IOException e1) {
            throw new IllegalStateException(e1);
        }
        if (this.timeout > -1) {
            urlConnection.setConnectTimeout(this.timeout);
            urlConnection.setReadTimeout(this.timeout);
        }
        return urlConnection;
    }

    public String toString() {
        return this.theURL.toString();
    }
}

