/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.exception;

import org.terracotta.exception.EntityException;

public class EntityVersionMismatchException
extends EntityException {
    private static final long serialVersionUID = 1L;
    private final long expectedVersion;
    private final long attemptedVersion;

    public EntityVersionMismatchException(String className, String entityName, long expectedVersion, long attemptedVersion) {
        super(className, entityName, "version mismatch (expected " + expectedVersion + " but attempted " + attemptedVersion + ")", null);
        this.expectedVersion = expectedVersion;
        this.attemptedVersion = attemptedVersion;
    }

    public EntityVersionMismatchException(String className, String entityName, long expectedVersion, long attemptedVersion, Throwable cause) {
        super(className, entityName, "version mismatch (expected " + expectedVersion + " but attempted " + attemptedVersion + ")", cause);
        this.expectedVersion = expectedVersion;
        this.attemptedVersion = attemptedVersion;
    }

    public long getExpectedVersion() {
        return this.expectedVersion;
    }

    public long getAttemptedVersion() {
        return this.attemptedVersion;
    }
}

