/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.EventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.async.impl.Event;
import com.tc.async.impl.EventCreator;
import com.tc.util.Assert;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectEventCreator<EC>
implements EventCreator<EC> {
    private final EventHandler<EC> handler;
    private final Supplier<Boolean> isIdle;
    private volatile boolean directInflight = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectEventCreator.class);
    private static final ThreadLocal<Thread> ACTIVATED = new ThreadLocal();

    public DirectEventCreator(EventHandler<EC> handler, Supplier<Boolean> isIdle) {
        this.handler = handler;
        this.isIdle = isIdle;
        Assert.assertNotNull(this.isIdle);
    }

    @Override
    public Event createEvent(EC event) {
        if (this.isSingleThreaded()) {
            try {
                this.directInflight = true;
                Assert.assertTrue(this.isIdle.get());
                this.handler.handleEvent(event);
                Assert.assertTrue(this.isIdle.get());
            }
            catch (EventHandlerException ee) {
                throw new RuntimeException(ee);
            }
            finally {
                this.directInflight = false;
            }
            return null;
        }
        if (this.directInflight) {
            throw new AssertionError();
        }
        return () -> this.handler.handleEvent(event);
    }

    public static void activate(boolean activate) {
        if (activate) {
            ACTIVATED.set(Thread.currentThread());
        } else {
            ACTIVATED.remove();
        }
    }

    public static boolean isActivated() {
        return ACTIVATED.get() == Thread.currentThread();
    }

    private boolean isSingleThreaded() {
        if (LOGGER.isDebugEnabled()) {
            if (DirectEventCreator.isActivated()) {
                return this.isIdle.get() != false;
            }
            return false;
        }
        return DirectEventCreator.isActivated() && this.isIdle.get() != false;
    }
}

