/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection.api;

import com.tc.object.ClientBuilderFactory;
import com.terracotta.connection.EndpointConnector;
import com.terracotta.connection.EndpointConnectorImpl;
import com.terracotta.connection.TerracottaConnection;
import com.terracotta.connection.TerracottaInternalClient;
import com.terracotta.connection.TerracottaInternalClientFactory;
import com.terracotta.connection.TerracottaInternalClientFactoryImpl;
import com.terracotta.connection.client.TerracottaClientConfigParams;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionService;

abstract class AbstractConnectionService
implements ConnectionService {
    private final String scheme;
    private final EndpointConnector endpointConnector;
    private final TerracottaInternalClientFactory clientFactory;

    AbstractConnectionService(String scheme) {
        this(scheme, new EndpointConnectorImpl(), new TerracottaInternalClientFactoryImpl());
    }

    AbstractConnectionService(String scheme, EndpointConnector endpointConnector, TerracottaInternalClientFactory clientFactory) {
        this.scheme = scheme;
        this.endpointConnector = endpointConnector;
        this.clientFactory = clientFactory;
    }

    @Override
    public boolean handlesURI(URI uri) {
        return this.scheme.equals(uri.getScheme());
    }

    @Override
    public final Connection connect(URI uri, Properties properties) throws ConnectionException {
        String[] hosts;
        if (!this.handlesURI(uri)) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        TerracottaClientConfigParams clientConfig = new TerracottaClientConfigParams();
        for (String host : hosts = uri.getSchemeSpecificPart().split(",")) {
            URI oneHost;
            if (0 != host.indexOf("//")) {
                host = "//" + host;
            }
            try {
                oneHost = new URI(host).parseServerAuthority();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to parse uri " + uri, e);
            }
            String userInfo = oneHost.getUserInfo();
            String stripeUri = (null != userInfo ? userInfo + "@" : "") + oneHost.getHost() + ":" + oneHost.getPort();
            clientConfig.addStripeMemberUri(stripeUri);
        }
        properties.put("client.builder.type", (Object)ClientBuilderFactory.ClientBuilderType.of(this.scheme));
        clientConfig.addGenericProperties(properties);
        TerracottaInternalClient client = this.clientFactory.createL1Client(clientConfig);
        try {
            client.init();
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
        return new TerracottaConnection(client.getClientEntityManager(), this.endpointConnector, client::shutdown);
    }
}

