/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.messages.ConfigCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.common.internal.messages.MessageCodecUtils;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class LifeCycleMessageCodec {
    private static final String CONFIG_PRESENT_FIELD = "configPresent";
    private final StructBuilder VALIDATE_MESSAGE_STRUCT_BUILDER_PREFIX = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).bool("configPresent", 30);
    private static final int CONFIGURE_MESSAGE_NEXT_INDEX = 40;
    private final StructBuilder VALIDATE_STORE_MESSAGE_STRUCT_BUILDER_PREFIX = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).string("serverStoreName", 30);
    private static final int VALIDATE_STORE_NEXT_INDEX = 40;
    private final Struct PREPARE_FOR_DESTROY_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).build();
    private final Struct validateMessageStruct;
    private final Struct validateStoreMessageStruct;
    private final MessageCodecUtils messageCodecUtils = new MessageCodecUtils();
    private final ConfigCodec configCodec;

    public LifeCycleMessageCodec(ConfigCodec configCodec) {
        this.configCodec = configCodec;
        this.validateMessageStruct = this.configCodec.injectServerSideConfiguration(this.VALIDATE_MESSAGE_STRUCT_BUILDER_PREFIX, 40).getUpdatedBuilder().build();
        this.validateStoreMessageStruct = this.configCodec.injectServerStoreConfiguration(this.VALIDATE_STORE_MESSAGE_STRUCT_BUILDER_PREFIX, 40).getUpdatedBuilder().build();
    }

    public byte[] encode(LifecycleMessage message) {
        switch (message.getMessageType()) {
            case VALIDATE: {
                return this.encodeTierManagerValidateMessage((LifecycleMessage.ValidateStoreManager)message);
            }
            case VALIDATE_SERVER_STORE: {
                return this.encodeValidateStoreMessage((LifecycleMessage.ValidateServerStore)message);
            }
            case PREPARE_FOR_DESTROY: {
                return this.encodePrepareForDestroyMessage(message);
            }
        }
        throw new IllegalArgumentException("Unknown lifecycle message: " + message.getClass());
    }

    private byte[] encodePrepareForDestroyMessage(LifecycleMessage message) {
        return ((StructEncoder)this.PREPARE_FOR_DESTROY_STRUCT.encoder().enm("opCode", (Object)message.getMessageType())).encode().array();
    }

    private byte[] encodeValidateStoreMessage(LifecycleMessage.ValidateServerStore message) {
        StructEncoder<Void> encoder = this.validateStoreMessageStruct.encoder();
        this.messageCodecUtils.encodeMandatoryFields(encoder, message);
        encoder.string("serverStoreName", message.getName());
        this.configCodec.encodeServerStoreConfiguration(encoder, message.getStoreConfiguration());
        return encoder.encode().array();
    }

    private byte[] encodeTierManagerValidateMessage(LifecycleMessage.ValidateStoreManager message) {
        StructEncoder<Void> encoder = this.validateMessageStruct.encoder();
        ServerSideConfiguration config = message.getConfiguration();
        this.messageCodecUtils.encodeMandatoryFields(encoder, message);
        if (config == null) {
            encoder.bool(CONFIG_PRESENT_FIELD, false);
        } else {
            encoder.bool(CONFIG_PRESENT_FIELD, true);
            this.configCodec.encodeServerSideConfiguration(encoder, config);
        }
        return encoder.encode().array();
    }

    public EhcacheEntityMessage decode(EhcacheMessageType messageType, ByteBuffer messageBuffer) {
        switch (messageType) {
            case VALIDATE: {
                return this.decodeValidateMessage(messageBuffer);
            }
            case VALIDATE_SERVER_STORE: {
                return this.decodeValidateServerStoreMessage(messageBuffer);
            }
            case PREPARE_FOR_DESTROY: {
                return this.decodePrepareForDestroyMessage();
            }
        }
        throw new IllegalArgumentException("LifeCycleMessage operation not defined for : " + (Object)((Object)messageType));
    }

    private LifecycleMessage.PrepareForDestroy decodePrepareForDestroyMessage() {
        return new LifecycleMessage.PrepareForDestroy();
    }

    private LifecycleMessage.ValidateServerStore decodeValidateServerStoreMessage(ByteBuffer messageBuffer) {
        StructDecoder<Void> decoder = this.validateStoreMessageStruct.decoder(messageBuffer);
        String storeName = decoder.string("serverStoreName");
        ServerStoreConfiguration config = this.configCodec.decodeServerStoreConfiguration(decoder);
        return new LifecycleMessage.ValidateServerStore(storeName, config);
    }

    private LifecycleMessage.ValidateStoreManager decodeValidateMessage(ByteBuffer messageBuffer) {
        StructDecoder<Void> decoder = this.validateMessageStruct.decoder(messageBuffer);
        boolean configPresent = decoder.bool(CONFIG_PRESENT_FIELD);
        ServerSideConfiguration config = null;
        if (configPresent) {
            config = this.configCodec.decodeServerSideConfiguration(decoder);
        }
        return new LifecycleMessage.ValidateStoreManager(config);
    }
}

