/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.config;

import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import org.ehcache.CacheManager;
import org.ehcache.PersistentCacheManager;
import org.ehcache.clustered.client.config.Timeouts;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.CacheManagerConfiguration;
import org.ehcache.core.HumanReadable;
import org.ehcache.spi.service.ServiceCreationConfiguration;

public class ClusteringServiceConfiguration
implements ServiceCreationConfiguration<ClusteringService>,
CacheManagerConfiguration<PersistentCacheManager>,
HumanReadable {
    private final URI clusterUri;
    private final boolean autoCreate;
    private final ServerSideConfiguration serverConfiguration;
    private final Timeouts timeouts;

    public ClusteringServiceConfiguration(URI clusterUri) {
        this(clusterUri, Timeouts.DEFAULT);
    }

    public ClusteringServiceConfiguration(URI clusterUri, Timeouts timeouts) {
        this(clusterUri, timeouts, null);
    }

    public ClusteringServiceConfiguration(URI clusterUri, ServerSideConfiguration serverConfig) {
        this(clusterUri, Timeouts.DEFAULT, serverConfig);
    }

    public ClusteringServiceConfiguration(URI clusterUri, Timeouts timeouts, ServerSideConfiguration serverConfig) {
        this(clusterUri, timeouts, false, serverConfig);
    }

    public ClusteringServiceConfiguration(URI clusterUri, boolean autoCreate, ServerSideConfiguration serverConfig) {
        this(clusterUri, Timeouts.DEFAULT, autoCreate, serverConfig);
    }

    public ClusteringServiceConfiguration(URI clusterUri, Timeouts timeouts, boolean autoCreate, ServerSideConfiguration serverConfig) {
        this.clusterUri = Objects.requireNonNull(clusterUri, "Cluster URI cannot be null");
        this.autoCreate = autoCreate;
        this.serverConfiguration = serverConfig;
        this.timeouts = Objects.requireNonNull(timeouts, "Operation timeouts cannot be null");
    }

    protected ClusteringServiceConfiguration(ClusteringServiceConfiguration baseConfig) {
        Objects.requireNonNull(baseConfig, "Base configuration cannot be null");
        this.clusterUri = baseConfig.getClusterUri();
        this.timeouts = baseConfig.getTimeouts();
        this.autoCreate = baseConfig.isAutoCreate();
        this.serverConfiguration = baseConfig.getServerConfiguration();
    }

    public URI getClusterUri() {
        return this.clusterUri;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public ServerSideConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    @Deprecated
    public Duration getReadOperationTimeout() {
        return this.timeouts.getReadOperationTimeout();
    }

    public Class<ClusteringService> getServiceType() {
        return ClusteringService.class;
    }

    public CacheManagerBuilder<PersistentCacheManager> builder(CacheManagerBuilder<? extends CacheManager> other) {
        return other.using((ServiceCreationConfiguration)this);
    }

    public String readableString() {
        return this.getClass().getName() + ":\n    clusterUri: " + this.getClusterUri() + "\n    timeouts: " + this.getTimeouts() + "\n    autoCreate: " + this.isAutoCreate() + "\n    defaultServerResource: " + this.serverConfiguration.getDefaultServerResource() + "\n    " + this.readablePoolsString();
    }

    private String readablePoolsString() {
        StringBuilder pools = new StringBuilder("resourcePools:\n");
        for (Map.Entry<String, ServerSideConfiguration.Pool> entry : this.serverConfiguration.getResourcePools().entrySet()) {
            pools.append("        " + entry.getKey() + ": " + entry.getValue() + "\n");
        }
        return pools.toString();
    }
}

