/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store.operations;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.ehcache.clustered.client.internal.store.ChainBuilder;
import org.ehcache.clustered.client.internal.store.ResolvedChain;
import org.ehcache.clustered.client.internal.store.operations.EternalChainResolver;
import org.ehcache.clustered.client.internal.store.operations.Operation;
import org.ehcache.clustered.client.internal.store.operations.PutOperation;
import org.ehcache.clustered.client.internal.store.operations.codecs.OperationsCodec;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChainResolver<K, V> {
    protected static final Logger LOG = LoggerFactory.getLogger(EternalChainResolver.class);
    protected static final TimeUnit TIME_UNIT = TimeUnit.MILLISECONDS;
    protected final OperationsCodec<K, V> codec;

    public ChainResolver(OperationsCodec<K, V> codec) {
        this.codec = codec;
    }

    public ResolvedChain<K, V> resolve(Chain chain, K key, long now) {
        Chain newChain;
        PutOperation<K, V> result = null;
        ChainBuilder newChainBuilder = new ChainBuilder();
        boolean matched = false;
        for (Element element : chain) {
            ByteBuffer payload = element.getPayload();
            Operation<K, V> operation = this.codec.decode(payload);
            if (key.equals(operation.getKey())) {
                matched = true;
                result = this.applyOperation(key, result, operation, now);
                continue;
            }
            payload.rewind();
            newChainBuilder = newChainBuilder.add(payload);
        }
        if (result == null) {
            if (matched) {
                newChain = newChainBuilder.build();
                return new ResolvedChain.Impl(newChain, key, null, chain.length() - newChain.length(), Long.MAX_VALUE);
            }
            return new ResolvedChain.Impl(chain, key, null, 0, Long.MAX_VALUE);
        }
        newChain = newChainBuilder.add(this.codec.encode(result)).build();
        return new ResolvedChain.Impl(newChain, key, result, chain.length() - newChain.length(), result.expirationTime());
    }

    public Chain applyOperation(Chain chain, long now) {
        HashMap<Object, PutOperation> compacted = new HashMap<Object, PutOperation>(2);
        for (Element element : chain) {
            ByteBuffer payload = element.getPayload();
            Operation<K, V> operation = this.codec.decode(payload);
            compacted.compute(operation.getKey(), (k, v) -> this.applyOperation((K)k, (PutOperation<K, V>)v, operation, now));
        }
        ChainBuilder builder = new ChainBuilder();
        for (PutOperation operation : compacted.values()) {
            builder = builder.add(this.codec.encode(operation));
        }
        return builder.build();
    }

    protected abstract PutOperation<K, V> applyOperation(K var1, PutOperation<K, V> var2, Operation<K, V> var3, long var4);
}

