/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.client.ClientFactory;
import com.tc.cluster.ClusterImpl;
import com.tc.config.schema.setup.ClientConfigurationSetupManagerFactory;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.L1ConfigurationSetupManager;
import com.tc.lang.L1ThrowableHandler;
import com.tc.lang.TCThreadGroup;
import com.tc.object.ClientBuilder;
import com.tc.object.DistributedObjectClient;
import com.tc.object.config.ClientConfigImpl;
import com.tc.object.config.PreparedComponentsFromL2Connection;
import com.tc.util.UUID;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.LoggerFactory;

public class DistributedObjectClientFactory {
    private final List<String> stripeMemberUris;
    private final ClientBuilder builder;
    private final Properties properties;

    public DistributedObjectClientFactory(List<String> stripeMemberUris, ClientBuilder builder, Properties properties) {
        this.stripeMemberUris = stripeMemberUris;
        this.builder = builder;
        this.properties = properties;
    }

    public DistributedObjectClient create() throws InterruptedException, ConfigurationSetupException {
        PreparedComponentsFromL2Connection connectionComponents;
        final AtomicReference clientRef = new AtomicReference();
        ClientConfigurationSetupManagerFactory factory = new ClientConfigurationSetupManagerFactory(null, this.stripeMemberUris);
        L1ConfigurationSetupManager config = factory.getL1TVSConfigurationSetupManager();
        try {
            connectionComponents = DistributedObjectClientFactory.validateMakeL2Connection(config);
        }
        catch (Exception e) {
            throw new ConfigurationSetupException(e.getLocalizedMessage(), e);
        }
        ClientConfigImpl configHelper = new ClientConfigImpl(config);
        L1ThrowableHandler throwableHandler = new L1ThrowableHandler(LoggerFactory.getLogger(DistributedObjectClient.class), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DistributedObjectClient client = (DistributedObjectClient)clientRef.get();
                if (client != null) {
                    client.shutdown();
                }
                return null;
            }
        });
        TCThreadGroup group = new TCThreadGroup(throwableHandler);
        ClusterImpl cluster = new ClusterImpl();
        String uuid = this.properties.getProperty("connection.uuid", UUID.getUUID().toString());
        String name = this.properties.getProperty("connection.name", "");
        DistributedObjectClient client = ClientFactory.createClient(configHelper, this.builder, group, connectionComponents, cluster, uuid, name);
        try {
            client.start();
            String timeout = this.properties.getProperty("connection.timeout", "0");
            if (!client.waitForConnection(Long.parseLong(timeout), TimeUnit.MILLISECONDS)) {
                client.shutdown();
                return null;
            }
        }
        catch (InterruptedException ie) {
            client.shutdown();
            return null;
        }
        catch (RuntimeException exp) {
            client.shutdown();
            throw exp;
        }
        catch (Error e) {
            client.shutdown();
            throw e;
        }
        cluster.init(client.getClusterEventsStage());
        return client;
    }

    private static PreparedComponentsFromL2Connection validateMakeL2Connection(L1ConfigurationSetupManager config) {
        return new PreparedComponentsFromL2Connection(config);
    }
}

