/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.TCSocketAddress;
import com.tc.net.core.TCConnection;
import com.tc.net.core.event.TCConnectionErrorEvent;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.protocol.transport.HealthCheckerSocketConnect;
import com.tc.net.protocol.transport.HealthCheckerSocketConnectEventListener;
import com.tc.util.Assert;
import com.tc.util.State;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;

public class HealthCheckerSocketConnectImpl
implements HealthCheckerSocketConnect {
    private final TCSocketAddress peerNodeAddr;
    private final TCConnection conn;
    private final Logger logger;
    private final int timeoutInterval;
    private final String remoteNodeDesc;
    private final CopyOnWriteArrayList<HealthCheckerSocketConnectEventListener> listeners = new CopyOnWriteArrayList();
    private State currentState;
    private short socketConnectNoReplyWaitCount = 0;
    private static final State SOCKETCONNECT_IDLE = new State("SOCKETCONNECT_IDLE");
    private static final State SOCKETCONNECT_IN_PROGRESS = new State("SOCKETCONNECT_IN_PROGRESS");
    private static final State SOCKETCONNECT_FAIL = new State("SOCKETCONNECT_FAIL");

    public HealthCheckerSocketConnectImpl(TCSocketAddress peerNode, TCConnection conn, String remoteNodeDesc, Logger logger, int timeoutInterval) {
        this.conn = conn;
        this.peerNodeAddr = peerNode;
        this.remoteNodeDesc = remoteNodeDesc;
        this.logger = logger;
        this.timeoutInterval = timeoutInterval;
        this.currentState = SOCKETCONNECT_IDLE;
    }

    private void changeState(State newState) {
        if (this.logger.isDebugEnabled() && this.currentState != newState) {
            this.logger.debug("Socket Connect Context state change for " + this.remoteNodeDesc + " : " + this.currentState.toString() + " ===> " + newState.toString());
        }
        this.currentState = newState;
    }

    @Override
    public synchronized HealthCheckerSocketConnect.SocketConnectStartStatus start() {
        Assert.eval(!this.currentState.equals(SOCKETCONNECT_IN_PROGRESS));
        this.socketConnectNoReplyWaitCount = 0;
        try {
            this.conn.addListener(this);
            this.conn.asynchConnect(this.peerNodeAddr);
        }
        catch (IOException e) {
            this.conn.removeListener(this);
            this.changeState(SOCKETCONNECT_FAIL);
            this.logger.info("Socket Connect to " + this.remoteNodeDesc + " failed: " + e);
            return HealthCheckerSocketConnect.SocketConnectStartStatus.FAILED;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Socket Connect triggered for " + this.remoteNodeDesc);
        }
        this.changeState(SOCKETCONNECT_IN_PROGRESS);
        return HealthCheckerSocketConnect.SocketConnectStartStatus.STARTED;
    }

    private void stop() {
        if (this.conn != null) {
            this.conn.removeListener(this);
            this.conn.asynchClose();
        }
    }

    @Override
    public void addSocketConnectEventListener(HealthCheckerSocketConnectEventListener socketConnectListener) {
        if (!this.listeners.addIfAbsent(socketConnectListener)) {
            throw new AssertionError((Object)("Attempt to add same socket connect event listener moere than once: " + socketConnectListener));
        }
    }

    @Override
    public void removeSocketConnectEventListener(HealthCheckerSocketConnectEventListener socketConnectListener) {
        if (!this.listeners.remove(socketConnectListener)) {
            throw new AssertionError((Object)"Attempt to remove non registered socket connect event listener");
        }
    }

    @Override
    public synchronized boolean probeConnectStatus() {
        if (this.currentState == SOCKETCONNECT_FAIL) {
            this.logger.info("Socket Connect to " + this.remoteNodeDesc + " listener port failed. Probably not reachable.");
            return false;
        }
        this.socketConnectNoReplyWaitCount = (short)(this.socketConnectNoReplyWaitCount + 1);
        if (this.socketConnectNoReplyWaitCount > this.timeoutInterval) {
            this.logger.info("Socket Connect to " + this.remoteNodeDesc + " taking long time. probably not reachable.");
            this.stop();
            this.changeState(SOCKETCONNECT_FAIL);
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Socket Connect to " + this.remoteNodeDesc + " listener port in progress.");
        }
        return true;
    }

    @Override
    public synchronized void closeEvent(TCConnectionEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectEvent(TCConnectionEvent event) {
        HealthCheckerSocketConnectImpl healthCheckerSocketConnectImpl = this;
        synchronized (healthCheckerSocketConnectImpl) {
            this.stop();
            this.changeState(SOCKETCONNECT_IDLE);
        }
        for (HealthCheckerSocketConnectEventListener listener : this.listeners) {
            listener.notifySocketConnectSuccess(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endOfFileEvent(TCConnectionEvent event) {
        HealthCheckerSocketConnectImpl healthCheckerSocketConnectImpl = this;
        synchronized (healthCheckerSocketConnectImpl) {
            this.stop();
            this.changeState(SOCKETCONNECT_FAIL);
        }
        for (HealthCheckerSocketConnectEventListener listener : this.listeners) {
            listener.notifySocketConnectFail(event);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Socket Connect EOF event:" + event.toString() + " on " + this.remoteNodeDesc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void errorEvent(TCConnectionErrorEvent errorEvent) {
        HealthCheckerSocketConnectImpl healthCheckerSocketConnectImpl = this;
        synchronized (healthCheckerSocketConnectImpl) {
            this.stop();
            this.changeState(SOCKETCONNECT_FAIL);
        }
        for (HealthCheckerSocketConnectEventListener listener : this.listeners) {
            listener.notifySocketConnectFail(errorEvent);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Socket Connect Error Event:" + errorEvent.toString() + " on " + this.remoteNodeDesc);
        }
    }
}

