/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.EventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.Sink;
import com.tc.async.impl.StageQueue;
import com.tc.stats.Stats;
import com.tc.util.Assert;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectSink<EC>
implements Sink<EC> {
    private final EventHandler<EC> handler;
    private final Supplier<Boolean> isIdle;
    private final StageQueue<EC> ifNotDirect;
    private volatile boolean directInflight = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectSink.class);
    private static final ThreadLocal<Thread> ACTIVATED = new ThreadLocal();

    public DirectSink(EventHandler<EC> handler, Supplier<Boolean> isIdle, StageQueue<EC> queue) {
        this.handler = handler;
        this.isIdle = isIdle;
        this.ifNotDirect = queue;
        Assert.assertNotNull(this.isIdle);
        Assert.assertNotNull(this.ifNotDirect);
    }

    private void pipeline(EC context, Consumer<EC> underlying) {
        if (this.isSingleThreaded()) {
            try {
                this.directInflight = true;
                Assert.assertTrue(this.isIdle.get());
                this.handler.handleEvent(context);
                Assert.assertTrue(this.isIdle.get());
            }
            catch (EventHandlerException ee) {
                throw new RuntimeException(ee);
            }
            finally {
                this.directInflight = false;
            }
        } else {
            if (this.directInflight) {
                throw new AssertionError();
            }
            underlying.accept(context);
        }
    }

    @Override
    public void addSingleThreaded(EC context) {
        this.pipeline(context, this.ifNotDirect::addSingleThreaded);
    }

    @Override
    public void addMultiThreaded(EC context) {
        this.pipeline(context, this.ifNotDirect::addMultiThreaded);
    }

    @Override
    public boolean isEmpty() {
        return !this.directInflight || this.ifNotDirect.isEmpty();
    }

    @Override
    public int size() {
        return this.ifNotDirect.size();
    }

    @Override
    public void clear() {
        this.ifNotDirect.clear();
    }

    @Override
    public void close() {
        this.ifNotDirect.close();
    }

    @Override
    public void enableStatsCollection(boolean enable) {
        this.ifNotDirect.enableStatsCollection(enable);
    }

    @Override
    public boolean isStatsCollectionEnabled() {
        return this.ifNotDirect.isStatsCollectionEnabled();
    }

    @Override
    public Stats getStats(long frequency) {
        return this.ifNotDirect.getStats(frequency);
    }

    @Override
    public Stats getStatsAndReset(long frequency) {
        return this.ifNotDirect.getStatsAndReset(frequency);
    }

    @Override
    public void resetStats() {
        this.ifNotDirect.resetStats();
    }

    public static void activate(boolean activate) {
        if (activate) {
            ACTIVATED.set(Thread.currentThread());
        } else {
            ACTIVATED.remove();
        }
    }

    public static boolean isActivated() {
        return ACTIVATED.get() == Thread.currentThread();
    }

    private boolean isSingleThreaded() {
        if (LOGGER.isDebugEnabled()) {
            if (DirectSink.isActivated()) {
                if (!this.isIdle.get().booleanValue()) {
                    LOGGER.debug("checked but not idle:" + this.ifNotDirect.toString());
                    return false;
                }
                return true;
            }
            return false;
        }
        return DirectSink.isActivated() && this.isIdle.get() != false;
    }
}

