/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.net.TCSocketAddress;
import com.tc.net.core.CoreNIOServices;
import com.tc.net.core.SocketParams;
import com.tc.net.core.TCComm;
import com.tc.net.core.TCCommImpl;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionImpl;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.core.TCListener;
import com.tc.net.core.TCListenerImpl;
import com.tc.net.core.event.TCConnectionErrorEvent;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.core.event.TCConnectionEventListener;
import com.tc.net.core.event.TCListenerEvent;
import com.tc.net.core.event.TCListenerEventListener;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.net.protocol.ProtocolAdaptorFactory;
import com.tc.net.protocol.TCProtocolAdaptor;
import com.tc.net.protocol.transport.ConnectionHealthCheckerUtil;
import com.tc.net.protocol.transport.HealthCheckerConfig;
import com.tc.net.protocol.transport.HealthCheckerConfigImpl;
import com.tc.util.concurrent.SetOnceFlag;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCConnectionManagerImpl
implements TCConnectionManager {
    protected static final TCConnection[] EMPTY_CONNECTION_ARRAY = new TCConnection[0];
    protected static final TCListener[] EMPTY_LISTENER_ARRAY = new TCListener[0];
    protected static final Logger logger = LoggerFactory.getLogger(TCConnectionManager.class);
    private final TCCommImpl comm;
    private final HealthCheckerConfig healthCheckerConfig;
    private final Set<TCConnection> connections = new HashSet<TCConnection>();
    private final Set<TCListener> listeners = new HashSet<TCListener>();
    private final SetOnceFlag shutdown = new SetOnceFlag();
    private final ConnectionEvents connEvents;
    private final ListenerEvents listenerEvents;
    private final SocketParams socketParams;
    private final TCSecurityManager securityManager;

    public TCConnectionManagerImpl() {
        this("ConnectionMgr", 0, new HealthCheckerConfigImpl("DefaultConfigForActiveConnections"), null);
    }

    public TCConnectionManagerImpl(String name, int workerCommCount, HealthCheckerConfig healthCheckerConfig, TCSecurityManager securityManager) {
        this.securityManager = securityManager;
        this.connEvents = new ConnectionEvents();
        this.listenerEvents = new ListenerEvents();
        this.socketParams = new SocketParams();
        this.healthCheckerConfig = healthCheckerConfig;
        this.comm = new TCCommImpl(name, workerCommCount, this.socketParams);
        this.comm.start();
    }

    protected TCConnection createConnectionImpl(TCProtocolAdaptor adaptor, TCConnectionEventListener listener) {
        return new TCConnectionImpl(listener, adaptor, this, this.comm.nioServiceThreadForNewConnection(), this.socketParams, this.securityManager);
    }

    protected TCListener createListenerImpl(TCSocketAddress addr, ProtocolAdaptorFactory factory, int backlog, boolean reuseAddr) throws IOException {
        ServerSocketChannel ssc = ServerSocketChannel.open();
        ssc.configureBlocking(false);
        ServerSocket serverSocket = ssc.socket();
        this.socketParams.applyServerSocketParams(serverSocket, reuseAddr);
        try {
            serverSocket.bind(new InetSocketAddress(addr.getAddress(), addr.getPort()), backlog);
        }
        catch (IOException ioe) {
            logger.warn("Unable to bind socket on address " + addr.getAddress() + ", port " + addr.getPort() + ", " + ioe.getMessage());
            throw ioe;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Bind: " + serverSocket.getLocalSocketAddress());
        }
        CoreNIOServices commThread = this.comm.nioServiceThreadForNewListener();
        TCListenerImpl rv = new TCListenerImpl(ssc, factory, this.getConnectionListener(), this, commThread, this.securityManager);
        commThread.registerListener(rv, ssc);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCConnection[] getAllConnections() {
        Set<TCConnection> set = this.connections;
        synchronized (set) {
            return this.connections.toArray(EMPTY_CONNECTION_ARRAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCConnection[] getAllActiveConnections() {
        Set<TCConnection> set = this.connections;
        synchronized (set) {
            ArrayList<TCConnection> activeConnections = new ArrayList<TCConnection>();
            long maxIdleTime = ConnectionHealthCheckerUtil.getMaxIdleTimeForAlive(this.healthCheckerConfig, false);
            for (TCConnection conn : this.connections) {
                if (conn.getIdleTime() < maxIdleTime && conn.isTransportEstablished()) {
                    activeConnections.add(conn);
                    continue;
                }
                logger.info(conn + "  is not active; Max allowed Idle time:" + maxIdleTime + "; Transport Established: " + conn.isTransportEstablished());
            }
            logger.info("Active connections : " + activeConnections.size() + " out of " + this.connections.size());
            return activeConnections.toArray(new TCConnection[activeConnections.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCListener[] getAllListeners() {
        Set<TCListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.toArray(EMPTY_LISTENER_ARRAY);
        }
    }

    @Override
    public final synchronized TCListener createListener(TCSocketAddress addr, ProtocolAdaptorFactory factory) throws IOException {
        return this.createListener(addr, factory, 512, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized TCListener createListener(TCSocketAddress addr, ProtocolAdaptorFactory factory, int backlog, boolean reuseAddr) throws IOException {
        this.checkShutdown();
        TCListener rv = this.createListenerImpl(addr, factory, backlog, reuseAddr);
        rv.addEventListener(this.listenerEvents);
        Set<TCListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(rv);
        }
        return rv;
    }

    @Override
    public final synchronized TCConnection createConnection(TCProtocolAdaptor adaptor) {
        this.checkShutdown();
        TCConnection rv = this.createConnectionImpl(adaptor, this.connEvents);
        this.newConnection(rv);
        return rv;
    }

    @Override
    public synchronized void closeAllConnections(long timeout) {
        this.closeAllConnections(false, timeout);
    }

    @Override
    public synchronized void asynchCloseAllConnections() {
        this.closeAllConnections(true, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllConnections(boolean async, long timeout) {
        TCConnection[] tCConnectionArray = this.connections;
        synchronized (this.connections) {
            TCConnection[] conns = this.connections.toArray(EMPTY_CONNECTION_ARRAY);
            // ** MonitorExit[var5_3] (shouldn't be in output)
            for (TCConnection conn : conns) {
                try {
                    if (async) {
                        conn.asynchClose();
                        continue;
                    }
                    conn.close(timeout);
                }
                catch (Exception e) {
                    logger.error("Exception trying to close " + conn, (Throwable)e);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void closeAllListeners() {
        TCListener[] tCListenerArray = this.listeners;
        synchronized (this.listeners) {
            TCListener[] list = this.listeners.toArray(EMPTY_LISTENER_ARRAY);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (TCListener lsnr : list) {
                try {
                    lsnr.stop();
                }
                catch (Exception e) {
                    logger.error("Exception trying to close " + lsnr, (Throwable)e);
                }
            }
            return;
        }
    }

    @Override
    public TCComm getTcComm() {
        return this.comm;
    }

    @Override
    public final synchronized void shutdown() {
        if (this.shutdown.attemptSet()) {
            this.closeAllListeners();
            this.asynchCloseAllConnections();
            this.comm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionClosed(TCConnection conn) {
        Set<TCConnection> set = this.connections;
        synchronized (set) {
            this.connections.remove(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newConnection(TCConnection conn) {
        Set<TCConnection> set = this.connections;
        synchronized (set) {
            this.connections.add(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(TCConnection connection) {
        Set<TCConnection> set = this.connections;
        synchronized (set) {
            this.connections.remove(connection);
        }
    }

    protected TCConnectionEventListener getConnectionListener() {
        return this.connEvents;
    }

    private final void checkShutdown() {
        if (this.shutdown.isSet()) {
            throw new IllegalStateException("connection manager shutdown");
        }
    }

    class ListenerEvents
    implements TCListenerEventListener {
        ListenerEvents() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closeEvent(TCListenerEvent event) {
            Set set = TCConnectionManagerImpl.this.listeners;
            synchronized (set) {
                TCConnectionManagerImpl.this.listeners.remove(event.getSource());
            }
        }
    }

    static class ConnectionEvents
    implements TCConnectionEventListener {
        ConnectionEvents() {
        }

        @Override
        public final void connectEvent(TCConnectionEvent event) {
            if (logger.isDebugEnabled()) {
                logger.debug("connect event: " + event.toString());
            }
        }

        @Override
        public final void closeEvent(TCConnectionEvent event) {
            if (logger.isDebugEnabled()) {
                logger.debug("close event: " + event.toString());
            }
        }

        @Override
        public final void errorEvent(TCConnectionErrorEvent event) {
            try {
                Exception err = event.getException();
                if (err != null) {
                    if (err instanceof IOException) {
                        if (logger.isInfoEnabled()) {
                            logger.info("error event on connection " + event.getSource() + ": " + err.getMessage());
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("error event on connection " + event.getSource() + ": " + err.getMessage(), (Throwable)err);
                        }
                    } else {
                        logger.error("Exception: ", (Throwable)err);
                    }
                }
            }
            finally {
                event.getSource().asynchClose();
            }
        }

        @Override
        public final void endOfFileEvent(TCConnectionEvent event) {
            if (logger.isDebugEnabled()) {
                logger.debug("EOF event: " + event.toString());
            }
            event.getSource().asynchClose();
        }
    }
}

