/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store.operations;

import java.util.Objects;
import org.ehcache.clustered.client.internal.store.operations.ChainResolver;
import org.ehcache.clustered.client.internal.store.operations.Operation;
import org.ehcache.clustered.client.internal.store.operations.PutOperation;
import org.ehcache.clustered.client.internal.store.operations.Result;
import org.ehcache.clustered.client.internal.store.operations.codecs.OperationsCodec;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;

public class ExpiryChainResolver<K, V>
extends ChainResolver<K, V> {
    private final Expiry<? super K, ? super V> expiry;

    public ExpiryChainResolver(OperationsCodec<K, V> codec, Expiry<? super K, ? super V> expiry) {
        super(codec);
        this.expiry = Objects.requireNonNull(expiry, "Expiry cannot be null");
    }

    @Override
    protected PutOperation<K, V> applyOperation(K key, PutOperation<K, V> existing, Operation<K, V> operation, long now) {
        Result<K, V> newValue = operation.apply(existing);
        if (newValue == null) {
            return null;
        }
        long expirationTime = this.calculateExpiryTime(key, existing, operation, newValue);
        if (now >= expirationTime) {
            return null;
        }
        return newValue.asOperationExpiringAt(expirationTime);
    }

    private long calculateExpiryTime(K key, PutOperation<K, V> existing, Operation<K, V> operation, Result<K, V> newValue) {
        if (operation.isExpiryAvailable()) {
            return operation.expirationTime();
        }
        try {
            Duration duration;
            if (existing == null) {
                duration = Objects.requireNonNull(this.expiry.getExpiryForCreation(key, newValue.getValue()));
            } else {
                duration = this.expiry.getExpiryForUpdate(key, existing::getValue, newValue.getValue());
                if (duration == null) {
                    return existing.expirationTime();
                }
            }
            if (duration.isInfinite()) {
                return Long.MAX_VALUE;
            }
            long time = TIME_UNIT.convert(duration.getLength(), duration.getTimeUnit());
            return time + operation.timeStamp();
        }
        catch (Exception ex) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)ex);
            return Long.MIN_VALUE;
        }
    }
}

