/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.config.TimeoutDuration;
import org.ehcache.clustered.client.internal.InternalClusterTierManagerClientEntity;
import org.ehcache.clustered.client.internal.Timeouts;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheResponseType;
import org.ehcache.clustered.common.internal.messages.LifeCycleMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;

public class SimpleClusterTierManagerClientEntity
implements InternalClusterTierManagerClientEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleClusterTierManagerClientEntity.class);
    private final EntityClientEndpoint<EhcacheEntityMessage, EhcacheEntityResponse> endpoint;
    private final LifeCycleMessageFactory messageFactory;
    private Timeouts timeouts = Timeouts.builder().build();

    public SimpleClusterTierManagerClientEntity(EntityClientEndpoint<EhcacheEntityMessage, EhcacheEntityResponse> endpoint) {
        this.endpoint = endpoint;
        this.messageFactory = new LifeCycleMessageFactory();
    }

    @Override
    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
    }

    @Override
    public void close() {
        this.endpoint.close();
    }

    @Override
    public void validate(ServerSideConfiguration config) throws ClusterException, TimeoutException {
        this.invokeInternal(this.timeouts.getLifecycleOperationTimeout(), this.messageFactory.validateStoreManager(config), false);
    }

    @Override
    public Set<String> prepareForDestroy() {
        try {
            EhcacheEntityResponse.PrepareForDestroy response = (EhcacheEntityResponse.PrepareForDestroy)this.invokeInternal(this.timeouts.getLifecycleOperationTimeout(), this.messageFactory.prepareForDestroy(), true);
            return response.getStores();
        }
        catch (TimeoutException | ClusterException exception) {
            return null;
        }
    }

    private EhcacheEntityResponse invokeInternal(TimeoutDuration timeLimit, EhcacheEntityMessage message, boolean replicate) throws ClusterException, TimeoutException {
        try {
            EhcacheEntityResponse response = SimpleClusterTierManagerClientEntity.waitFor(timeLimit, this.invokeAsync(message, replicate));
            if (EhcacheResponseType.FAILURE.equals((Object)response.getResponseType())) {
                throw ((EhcacheEntityResponse.Failure)response).getCause();
            }
            return response;
        }
        catch (MessageCodecException | EntityException e) {
            throw new RuntimeException(message + " error: " + e.toString(), e);
        }
        catch (TimeoutException e) {
            String msg = "Timeout exceeded for " + message + " message; " + timeLimit;
            TimeoutException timeoutException = new TimeoutException(msg);
            timeoutException.initCause(e);
            LOGGER.info(msg, (Throwable)timeoutException);
            throw timeoutException;
        }
    }

    private InvokeFuture<EhcacheEntityResponse> invokeAsync(EhcacheEntityMessage message, boolean replicate) throws MessageCodecException {
        return this.endpoint.beginInvoke().message(message).replicate(replicate).invoke();
    }

    private static <T extends EntityResponse> T waitFor(TimeoutDuration timeLimit, InvokeFuture<T> future) throws EntityException, TimeoutException {
        boolean interrupted = false;
        long deadlineTimeout = System.nanoTime() + timeLimit.toNanos();
        while (true) {
            try {
                long timeRemaining = deadlineTimeout - System.nanoTime();
                T t = future.getWithTimeout(timeRemaining, TimeUnit.NANOSECONDS);
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

