/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.diagnostic;

import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.net.core.SecurityInfo;
import com.tc.object.ClientEntityManager;
import com.tc.object.DistributedObjectClient;
import com.tc.object.DistributedObjectClientFactory;
import com.terracotta.connection.TerracottaInternalClient;
import com.terracotta.connection.client.TerracottaClientStripeConnectionConfig;
import com.terracotta.diagnostic.DiagnosticClientBuilder;
import java.util.Properties;
import java.util.concurrent.TimeoutException;

public class DiagnosticClientImpl
implements TerracottaInternalClient {
    private final DistributedObjectClientFactory clientCreator;
    private volatile DistributedObjectClient client;
    private volatile boolean shutdown = false;
    private volatile boolean isInitialized = false;

    public DiagnosticClientImpl(TerracottaClientStripeConnectionConfig stripeConnectionConfig, Properties properties) {
        try {
            this.clientCreator = this.buildClientCreator(stripeConnectionConfig, properties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DistributedObjectClientFactory buildClientCreator(TerracottaClientStripeConnectionConfig stripeConnectionConfig, Properties props) {
        return new DistributedObjectClientFactory(stripeConnectionConfig.getStripeMemberUris(), new DiagnosticClientBuilder(), null, new SecurityInfo(false, null), props);
    }

    @Override
    public synchronized void init() throws TimeoutException, InterruptedException, ConfigurationSetupException {
        if (this.isInitialized) {
            return;
        }
        DistributedObjectClient c = this.clientCreator.create();
        if (c == null) {
            throw new TimeoutException();
        }
        this.client = c;
    }

    @Override
    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public synchronized void shutdown() {
        this.shutdown = true;
        try {
            if (this.client != null) {
                this.client.shutdown();
            }
        }
        finally {
            this.client = null;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public ClientEntityManager getClientEntityManager() {
        return this.client.getEntityManager();
    }

    static class ClientShutdownException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ClientShutdownException() {
        }
    }
}

