/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.net.TCSocketAddress;
import com.tc.net.core.CoreNIOServices;
import com.tc.net.core.SocketParams;
import com.tc.net.core.TCConnectionImpl;
import com.tc.net.core.TCConnectionManagerImpl;
import com.tc.net.core.TCListener;
import com.tc.net.core.event.TCConnectionEventListener;
import com.tc.net.core.event.TCListenerEvent;
import com.tc.net.core.event.TCListenerEventListener;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.net.protocol.ProtocolAdaptorFactory;
import com.tc.net.protocol.TCProtocolAdaptor;
import com.tc.util.Assert;
import com.tc.util.TCTimeoutException;
import com.tc.util.concurrent.SetOnceFlag;
import com.tc.util.concurrent.TCExceptionResultException;
import com.tc.util.concurrent.TCFuture;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TCListenerImpl
implements TCListener {
    protected static final Logger logger = LoggerFactory.getLogger(TCListener.class);
    private final ServerSocketChannel ssc;
    private final TCConnectionEventListener listener;
    private final TCConnectionManagerImpl parent;
    private final InetAddress addr;
    private final int port;
    private final TCSocketAddress sockAddr;
    private final TCListenerEvent staticEvent;
    private final SetOnceFlag closeEventFired = new SetOnceFlag();
    private final SetOnceFlag stopPending = new SetOnceFlag();
    private final SetOnceFlag stopped = new SetOnceFlag();
    private final CopyOnWriteArraySet<TCListenerEventListener> listeners = new CopyOnWriteArraySet();
    private final ProtocolAdaptorFactory factory;
    private final CoreNIOServices commNIOServiceThread;
    private final TCSecurityManager securityManager;

    TCListenerImpl(ServerSocketChannel ssc, ProtocolAdaptorFactory factory, TCConnectionEventListener listener, TCConnectionManagerImpl managerJDK14, CoreNIOServices commNIOServiceThread, TCSecurityManager securityManager) {
        this.securityManager = securityManager;
        this.addr = ssc.socket().getInetAddress();
        this.port = ssc.socket().getLocalPort();
        this.sockAddr = new TCSocketAddress(this.addr, this.port);
        this.factory = factory;
        this.staticEvent = new TCListenerEvent(this);
        this.ssc = ssc;
        this.listener = listener;
        this.parent = managerJDK14;
        this.commNIOServiceThread = commNIOServiceThread;
    }

    protected void stopImpl(Runnable callback) {
        this.commNIOServiceThread.stopListener(this.ssc, callback);
    }

    TCConnectionImpl createConnection(SocketChannel ch, CoreNIOServices nioServiceThread, SocketParams socketParams) throws IOException {
        TCProtocolAdaptor adaptor = this.getProtocolAdaptorFactory().getInstance();
        TCConnectionImpl rv = new TCConnectionImpl(this.listener, adaptor, ch, this.parent, nioServiceThread, socketParams, this.securityManager);
        rv.finishConnect();
        this.parent.newConnection(rv);
        return rv;
    }

    @Override
    public final void stop() {
        try {
            this.stop(0L);
        }
        catch (Exception e) {
            logger.error("unexpected exception", (Throwable)e);
        }
    }

    @Override
    public final TCSocketAddress getBindSocketAddress() {
        return this.sockAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop(long timeout) throws TCTimeoutException {
        if (this.stopped.isSet()) {
            logger.warn("listener already stopped");
            return;
        }
        if (this.stopPending.attemptSet()) {
            final TCFuture future = new TCFuture();
            this.stopImpl(new Runnable(){

                @Override
                public void run() {
                    future.set("stop done");
                }
            });
            try {
                future.get(timeout);
            }
            catch (InterruptedException e) {
                logger.warn("stop interrupted");
                Thread.currentThread().interrupt();
                return;
            }
            catch (TCExceptionResultException e) {
                logger.error("Exception: ", (Throwable)e);
                Assert.eval("exception result set in future", false);
                return;
            }
            finally {
                this.fireCloseEvent();
                this.stopped.set();
            }
        } else {
            logger.warn("stop already requested");
        }
    }

    @Override
    public final int getBindPort() {
        return this.port;
    }

    @Override
    public final InetAddress getBindAddress() {
        return this.addr;
    }

    @Override
    public final void addEventListener(TCListenerEventListener lsnr) {
        if (lsnr == null) {
            logger.warn("trying to add a null event listener");
            return;
        }
        this.listeners.add(lsnr);
    }

    @Override
    public final void removeEventListener(TCListenerEventListener lsnr) {
        if (lsnr == null) {
            logger.warn("trying to remove a null event listener");
            return;
        }
        this.listeners.remove(lsnr);
    }

    @Override
    public final boolean isStopped() {
        return this.stopped.isSet();
    }

    public final String toString() {
        return this.getClass().getName() + " " + this.addr.getHostAddress() + ":" + this.port;
    }

    protected final void fireCloseEvent() {
        if (this.closeEventFired.attemptSet()) {
            for (TCListenerEventListener lsnr : this.listeners) {
                try {
                    lsnr.closeEvent(this.staticEvent);
                }
                catch (Exception e) {
                    logger.error("exception in close event handler", (Throwable)e);
                }
            }
        }
    }

    final ProtocolAdaptorFactory getProtocolAdaptorFactory() {
        return this.factory;
    }
}

