/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.EventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.Sink;
import com.tc.async.impl.StageQueue;
import com.tc.stats.Stats;
import com.tc.util.Assert;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectSink<EC>
implements Sink<EC> {
    private final EventHandler<EC> handler;
    private final Supplier<Boolean> isIdle;
    private final StageQueue<EC> ifNotDirect;
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectSink.class);
    private static final ThreadLocal<Thread> ACTIVATED = new ThreadLocal();

    public DirectSink(EventHandler<EC> handler, Supplier<Boolean> isIdle, StageQueue<EC> queue) {
        this.handler = handler;
        this.isIdle = isIdle;
        this.ifNotDirect = queue;
        Assert.assertNotNull(this.isIdle);
        Assert.assertNotNull(this.ifNotDirect);
    }

    @Override
    public void addSingleThreaded(EC context) {
        if (this.isSingleThreaded()) {
            try {
                Assert.assertTrue(this.isIdle.get());
                this.handler.handleEvent(context);
                Assert.assertTrue(this.isIdle.get());
            }
            catch (EventHandlerException ee) {
                throw new RuntimeException(ee);
            }
        } else {
            this.ifNotDirect.addSingleThreaded(context);
        }
    }

    @Override
    public void addMultiThreaded(EC context) {
        if (this.isSingleThreaded()) {
            try {
                Assert.assertTrue(this.isIdle.get());
                this.handler.handleEvent(context);
                Assert.assertTrue(this.isIdle.get());
            }
            catch (EventHandlerException ee) {
                throw new RuntimeException(ee);
            }
        } else {
            this.ifNotDirect.addMultiThreaded(context);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.ifNotDirect.isEmpty();
    }

    @Override
    public int size() {
        return this.ifNotDirect.size();
    }

    @Override
    public void clear() {
        this.ifNotDirect.clear();
    }

    @Override
    public void close() {
        this.ifNotDirect.close();
    }

    @Override
    public void enableStatsCollection(boolean enable) {
        this.ifNotDirect.enableStatsCollection(enable);
    }

    @Override
    public boolean isStatsCollectionEnabled() {
        return this.ifNotDirect.isStatsCollectionEnabled();
    }

    @Override
    public Stats getStats(long frequency) {
        return this.ifNotDirect.getStats(frequency);
    }

    @Override
    public Stats getStatsAndReset(long frequency) {
        return this.ifNotDirect.getStatsAndReset(frequency);
    }

    @Override
    public void resetStats() {
        this.ifNotDirect.resetStats();
    }

    public static void activate(boolean activate) {
        if (activate) {
            ACTIVATED.set(Thread.currentThread());
        } else {
            ACTIVATED.remove();
        }
    }

    public static boolean isActivated() {
        return ACTIVATED.get() == Thread.currentThread();
    }

    private boolean isSingleThreaded() {
        return ACTIVATED.get() == Thread.currentThread() && this.isIdle.get() != false;
    }
}

