/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal;

import java.io.Serializable;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.clustered.common.PoolAllocation;

public class ServerStoreConfiguration
implements Serializable {
    private static final long serialVersionUID = 5452646838836730816L;
    private final PoolAllocation poolAllocation;
    private final String storedKeyType;
    private final String storedValueType;
    private final String keySerializerType;
    private final String valueSerializerType;
    private final Consistency consistency;

    public ServerStoreConfiguration(PoolAllocation poolAllocation, String storedKeyType, String storedValueType, String keySerializerType, String valueSerializerType, Consistency consistency) {
        this.poolAllocation = poolAllocation;
        this.storedKeyType = storedKeyType;
        this.storedValueType = storedValueType;
        this.keySerializerType = keySerializerType;
        this.valueSerializerType = valueSerializerType;
        this.consistency = consistency;
    }

    public PoolAllocation getPoolAllocation() {
        return this.poolAllocation;
    }

    public String getStoredKeyType() {
        return this.storedKeyType;
    }

    public String getStoredValueType() {
        return this.storedValueType;
    }

    public String getKeySerializerType() {
        return this.keySerializerType;
    }

    public String getValueSerializerType() {
        return this.valueSerializerType;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public boolean isCompatible(ServerStoreConfiguration otherConfiguration, StringBuilder sb) {
        boolean isCompatible = true;
        isCompatible = isCompatible && this.compareField(sb, "storedKeyType", this.storedKeyType, otherConfiguration.getStoredKeyType());
        isCompatible = isCompatible && this.compareField(sb, "storedValueType", this.storedValueType, otherConfiguration.getStoredValueType());
        isCompatible = isCompatible && this.compareField(sb, "keySerializerType", this.keySerializerType, otherConfiguration.getKeySerializerType());
        isCompatible = isCompatible && this.compareField(sb, "valueSerializerType", this.valueSerializerType, otherConfiguration.getValueSerializerType());
        isCompatible = isCompatible && this.compareConsistencyField(sb, this.consistency, otherConfiguration.getConsistency());
        isCompatible = isCompatible && this.comparePoolAllocation(sb, otherConfiguration.getPoolAllocation());
        return isCompatible;
    }

    private boolean comparePoolAllocation(StringBuilder sb, PoolAllocation clientPoolAllocation) {
        if (this.poolAllocation.isCompatible(clientPoolAllocation)) {
            return true;
        }
        this.appendFault(sb, "resourcePoolType", this.poolAllocation, clientPoolAllocation);
        return false;
    }

    private String getClassName(Object obj) {
        if (obj != null) {
            return obj.getClass().getName();
        }
        return null;
    }

    private boolean compareConsistencyField(StringBuilder sb, Consistency serverConsistencyValue, Consistency clientConsistencyValue) {
        if (serverConsistencyValue == null && clientConsistencyValue == null || serverConsistencyValue != null && serverConsistencyValue.equals((Object)clientConsistencyValue)) {
            return true;
        }
        this.appendFault(sb, "consistencyType", (Object)serverConsistencyValue, (Object)clientConsistencyValue);
        return false;
    }

    private boolean compareField(StringBuilder sb, String fieldName, String serverConfigValue, String clientConfigValue) {
        if (serverConfigValue == null && clientConfigValue == null || serverConfigValue != null && serverConfigValue.equals(clientConfigValue)) {
            return true;
        }
        this.appendFault(sb, fieldName, serverConfigValue, clientConfigValue);
        return false;
    }

    private void appendFault(StringBuilder sb, String fieldName, Object serverConfigValue, Object clientConfigValue) {
        sb.append("\n\t").append(fieldName).append(" existing: ").append(serverConfigValue).append(", desired: ").append(clientConfigValue);
    }
}

