/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.core.ConnectionInfo;
import com.tc.net.protocol.transport.ClientConnectionErrorListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ClientConnectionErrorDetails
implements ClientConnectionErrorListener {
    private final ConcurrentHashMap<ConnectionInfo, ConcurrentLinkedQueue<Exception>> exceptionMap = new ConcurrentHashMap();

    @Override
    public void onError(ConnectionInfo connInfo, Exception e) {
        ConcurrentLinkedQueue<Exception> exceptionList = this.exceptionMap.get(connInfo);
        if (exceptionList == null) {
            exceptionList = new ConcurrentLinkedQueue();
            this.exceptionMap.put(connInfo, exceptionList);
        }
        exceptionList.add(e);
    }

    public Map<String, List<Exception>> getErrors() {
        HashMap<String, List<Exception>> errorMessagesMap = new HashMap<String, List<Exception>>();
        if (this.exceptionMap != null) {
            for (Map.Entry<ConnectionInfo, ConcurrentLinkedQueue<Exception>> entry : this.exceptionMap.entrySet()) {
                ConnectionInfo connInfo = entry.getKey();
                ConcurrentLinkedQueue<Exception> exceptionList = entry.getValue();
                Object[] errorObjects = exceptionList.toArray();
                ArrayList<Exception> errorMessages = new ArrayList<Exception>();
                for (Object errorObj : errorObjects) {
                    Exception e = (Exception)errorObj;
                    errorMessages.add(e);
                }
                errorMessagesMap.put(connInfo.toString(), errorMessages);
            }
        }
        return errorMessagesMap;
    }
}

