/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.net.core.AbstractBufferManager;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClearTextBufferManager
extends AbstractBufferManager {
    private static final Logger logger = LoggerFactory.getLogger(ClearTextBufferManager.class);
    private static final String BUFFER_SIZE = "clear.text.buffer.size";
    private static final int BUFFER_SIZE_KB = Integer.getInteger("clear.text.buffer.size", 16) * 1024;
    private final SocketChannel channel;
    private final ByteBuffer sendBuffer = ByteBuffer.allocate(BUFFER_SIZE_KB);
    private final ByteBuffer recvBuffer = ByteBuffer.allocate(BUFFER_SIZE_KB);

    ClearTextBufferManager(SocketChannel channel) {
        this.channel = channel;
        if (logger.isDebugEnabled()) {
            logger.debug("ClearTextBufferManager clear.text.buffer.size " + BUFFER_SIZE_KB);
        }
    }

    @Override
    public int sendFromBuffer() throws IOException {
        this.sendBuffer.flip();
        int written = this.channel.write(this.sendBuffer);
        this.sendBuffer.compact();
        if (written == -1) {
            throw new EOFException();
        }
        return written;
    }

    @Override
    public int recvToBuffer() throws IOException {
        int read = this.channel.read(this.recvBuffer);
        if (read == -1) {
            throw new EOFException();
        }
        return read;
    }

    @Override
    public void close() {
    }

    @Override
    protected ByteBuffer getRecvBuffer() {
        return this.recvBuffer;
    }

    @Override
    protected ByteBuffer getSendBuffer() {
        return this.sendBuffer;
    }
}

