/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection.api;

import com.tc.config.schema.setup.ConfigurationSetupException;
import com.terracotta.connection.EndpointConnector;
import com.terracotta.connection.EndpointConnectorImpl;
import com.terracotta.connection.TerracottaConnection;
import com.terracotta.connection.TerracottaInternalClient;
import com.terracotta.connection.TerracottaInternalClientStaticFactory;
import com.terracotta.connection.api.AbstractConnectionService;
import com.terracotta.connection.client.TerracottaClientConfigParams;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;

public class TerracottaConnectionService
extends AbstractConnectionService {
    private static final String SCHEME = "terracotta";
    private final EndpointConnector endpointConnector;

    @Override
    public boolean handlesURI(URI uri) {
        return SCHEME.equals(uri.getScheme());
    }

    public TerracottaConnectionService() {
        this(new EndpointConnectorImpl());
    }

    public TerracottaConnectionService(EndpointConnector endpointConnector) {
        this.endpointConnector = endpointConnector;
    }

    @Override
    public Connection internalConnect(TerracottaClientConfigParams clientConfig) throws ConnectionException {
        final TerracottaInternalClient client = TerracottaInternalClientStaticFactory.getOrCreateTerracottaInternalClient(clientConfig);
        try {
            client.init();
        }
        catch (TimeoutException exp) {
            throw new ConnectionException(exp);
        }
        catch (ConfigurationSetupException config) {
            throw new ConnectionException(config);
        }
        catch (InterruptedException ie) {
            throw new ConnectionException(ie);
        }
        return new TerracottaConnection(client.getClientEntityManager(), this.endpointConnector, new Runnable(){

            @Override
            public void run() {
                client.shutdown();
            }
        });
    }
}

