/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.concurrent;

import com.tc.exception.TCInternalError;
import com.tc.util.TCTimeoutException;
import com.tc.util.concurrent.TCExceptionResultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCFuture {
    private static final Logger logger = LoggerFactory.getLogger(TCFuture.class);
    private volatile boolean set;
    private volatile boolean cancel;
    private volatile boolean timedOut;
    private volatile Throwable exception;
    private volatile Object value;
    private final Object lock;

    public TCFuture() {
        this(null);
    }

    public TCFuture(Object lock) {
        this.lock = lock == null ? this : lock;
        this.cancel = false;
        this.value = null;
        this.exception = null;
        this.set = false;
    }

    public Object get() throws InterruptedException, TCExceptionResultException {
        try {
            return this.get(0L);
        }
        catch (TCTimeoutException e) {
            throw new TCInternalError("Timeout not supposed to happen here");
        }
    }

    public Object get(long timeout) throws InterruptedException, TCTimeoutException, TCExceptionResultException {
        return this.get(timeout, true);
    }

    public Object get(long timeout, boolean flagIfTimedOut) throws InterruptedException, TCTimeoutException, TCExceptionResultException {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancel) {
                throw new InterruptedException("Future already cancelled");
            }
            while (!this.set) {
                if (timeout < 0L) {
                    throw new TCTimeoutException("Timeout of " + timeout + " milliseconds occurred");
                }
                this.lock.wait(timeout);
                if (this.cancel) {
                    throw new InterruptedException("Future was cancelled while waiting");
                }
                if (this.set || timeout == 0L) continue;
                this.timedOut = flagIfTimedOut;
                throw new TCTimeoutException("Timeout of " + timeout + " milliseconds occured");
            }
            if (this.exception == null) {
                return this.value;
            }
            if (this.exception != null) {
                throw new TCExceptionResultException(this.exception);
            }
            throw new TCInternalError("Neither exception nor value set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(Throwable ex) {
        if (ex == null) {
            throw new IllegalArgumentException("exception result cannot be null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.cancel) {
                return;
            }
            if (this.set) {
                throw new IllegalStateException("Future result already set");
            }
            this.set = true;
            this.exception = ex;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object value) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancel) {
                return;
            }
            if (this.set) {
                throw new IllegalStateException("Value already set");
            }
            this.set = true;
            this.value = value;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.cancel = true;
            this.lock.notifyAll();
        }
    }

    public boolean timedOut() {
        return this.timedOut;
    }
}

